/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.net;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.net.ServerManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class Server
extends Thread {
    protected Logger logger = Logger.getLogger((String)this.getName());
    protected ServerManager parent;
    protected Environment env;
    protected Engine e;
    protected ServerSocket listener;
    protected boolean active = true;

    public Server(ServerManager parent, int port, Configuration config) throws IOException {
        super((ThreadGroup)parent, Server.buildName(port, config));
        this.logger.info((Object)("Starting server: " + this.getName()));
        this.env = parent.getEnvironment();
        this.e = this.env.getEngine(config);
        this.listener = new ServerSocket(port);
        this.listener.setSoTimeout(10);
        this.logger.info((Object)("Server running: " + this.getName()));
    }

    protected static String buildName(int port, Configuration config) {
        String dbName = config.getDBName();
        String fullEngineName = config.getEngineName();
        String engineName = fullEngineName.substring(fullEngineName.lastIndexOf(46) + 1);
        String fullProverName = config.getProverFactoryName();
        String proverName = null;
        if (fullProverName != null) {
            proverName = fullProverName.substring(fullProverName.lastIndexOf(46) + 1);
        }
        return "Server [" + dbName + " : " + engineName + (proverName != null ? "(" + proverName + ")" : "") + " : " + port + "]";
    }

    public ServerManager getParent() {
        return (ServerManager)this.getThreadGroup();
    }

    public void run() {
        while (this.active) {
            try {
                this.listen();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Throwable t) {
                this.logger.error((Object)"Caught exception.", t);
            }
        }
    }

    public void interrupt() {
        this.logger.debug((Object)"interrupting the thread.");
        this.active = false;
        try {
            this.listener.close();
        }
        catch (Throwable t) {
            this.logger.debug((Object)"Exception caught while closing the socket.", t);
        }
        super.interrupt();
    }

    public void listen() throws Exception {
        Socket receiver = this.listener.accept();
        this.logger.debug((Object)("Receiving transmition...: " + receiver));
        this.process(receiver);
        receiver.close();
    }

    public void process(Socket receiver) throws Exception {
        InputStreamReader in = new InputStreamReader(receiver.getInputStream());
        OutputStreamWriter out = new OutputStreamWriter(receiver.getOutputStream());
        String query = "";
        int ch = 0;
        while ((ch = ((Reader)in).read()) != -1) {
            query = String.valueOf(query) + (char)ch;
            if (ch != 59) continue;
        }
        this.logger.debug((Object)("received the query:" + query));
        String result = "";
        try {
            TupleStream ts = this.e.getConsistentAnswer(query);
            int i = 0;
            while (ts.hasNext()) {
                ++i;
                Tuple t = ts.getNext();
                StringBuffer tmp = new StringBuffer();
                int j = 0;
                while (j < t.getFieldCount()) {
                    tmp.append(t.getObject(j));
                    ++j;
                }
            }
            result = "" + i;
        }
        catch (Throwable t) {
            result = "Exception caught while processiong the query.\n";
            StringWriter s = new StringWriter();
            t.printStackTrace(new PrintWriter((Writer)s, true));
            result = String.valueOf(result) + s.toString();
        }
        out.write(result);
        ((Writer)out).flush();
        ((Writer)out).close();
        Runtime.getRuntime().gc();
    }

    public void shutdown() {
        try {
            this.logger.debug((Object)"shutting down");
            this.env.dispose(this.e);
            this.listener.close();
        }
        catch (Exception exc) {
            this.logger.error((Object)"Caught exception while shutdown.", (Throwable)exc);
        }
    }
}

