/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.prolog;

import edu.buffalo.nsf.hippo.data.DataSourceCache;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;

public class Elaboration {
    public static final Object U = new String("Unknown");
    public static final Object T = new String("True");
    public static final Object F = new String("False");
    public static final Elaboration UNKNOWN = new Elaboration(U);
    public static final Elaboration TRUE = new Elaboration(T);
    public static final Elaboration FALSE = new Elaboration(F);
    protected Object result;
    protected DataSourceCache cache;
    protected Hypergraph h;

    public Elaboration(Object result) {
        this.result = result;
    }

    public Elaboration(Object result, DataSourceCache cache) {
        this(result);
        this.cache = cache;
    }

    public Elaboration(Object result, Hypergraph h) {
        this(result);
        this.h = h;
    }

    public static Elaboration create(boolean b) {
        if (b) {
            return TRUE;
        }
        return FALSE;
    }

    public static Elaboration create(Object s) {
        if (s.equals(T)) {
            return TRUE;
        }
        if (s.equals(F)) {
            return FALSE;
        }
        return UNKNOWN;
    }

    public Object getResult() {
        return this.result;
    }

    public DataSourceCache getDataSourceCache() {
        return this.cache;
    }

    public Hypergraph getHypergraph() {
        return this.h;
    }

    public boolean isTrue() {
        return this.result == T;
    }

    public boolean isFalse() {
        return this.result == F;
    }

    public boolean isUnknown() {
        return this.result == U;
    }

    public String toString() {
        return this.result.toString();
    }
}

