/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.prolog;

import edu.buffalo.nsf.hippo.data.formula.Atom;
import edu.buffalo.nsf.hippo.data.formula.Conjunction;
import edu.buffalo.nsf.hippo.data.formula.Disjunction;
import edu.buffalo.nsf.hippo.data.formula.Formula;
import edu.buffalo.nsf.hippo.data.formula.Negation;
import edu.buffalo.nsf.hippo.data.graph.Edge;
import edu.buffalo.nsf.hippo.data.graph.Vertex;
import edu.buffalo.nsf.hippo.data.query.traverse.SJUIDTranslator;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.prolog.Elaboration;
import edu.buffalo.nsf.hippo.prolog.Prover;
import edu.buffalo.nsf.hippo.prolog.ProverEnv;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class HProver
extends Prover {
    protected static Logger logger;
    protected Formula f;
    protected ProverEnv basic;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.prolog.HProver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public HProver(Formula f, ProverEnv basic) {
        this.f = f.toCNF();
        this.basic = basic;
    }

    public Elaboration elaborate(Tuple t) {
        return this.elaborate(this.basic, t);
    }

    public Elaboration elaborate(ProverEnv env, Tuple t) {
        Map s = SJUIDTranslator.createSubstitution(t);
        Formula g = this.f.substitute(s);
        return Elaboration.create(this.isConsistent(env, g));
    }

    protected boolean isConsistent(ProverEnv env, Formula g) {
        try {
            List conjs = ((Conjunction)g).getConjuncts();
            boolean result = true;
            int i = 0;
            while (result && i < conjs.size()) {
                Disjunction d = (Disjunction)conjs.get(i);
                result = result && !this.isInconsistent(env, d);
                ++i;
            }
            return result;
        }
        catch (ClassCastException exc) {
            logger.error((Object)"class cast exception", (Throwable)exc);
            throw new IllegalArgumentException("Formula not in CNF or wrong work of the negation operation.");
        }
    }

    protected boolean isInconsistent(ProverEnv env, Disjunction d) {
        boolean result = true;
        Conjunction c = (Conjunction)d.negate();
        Set pos = this.toVertexSet(this.getPositiveLiterals(c));
        List neg = this.toVertexList(this.getNegativeLiterals(c));
        result = result && env.getHypergraph().contains(pos);
        result = result && this.consistentModelCheck(env, neg, pos);
        return result;
    }

    protected boolean consistentModelCheck(ProverEnv env, List negative, Set s) {
        boolean result = false;
        if (negative.isEmpty()) {
            result = env.getHypergraph().isIndependent(s);
        } else {
            Vertex v = (Vertex)negative.remove(0);
            if (!env.getHypergraph().contains(v)) {
                result = this.consistentModelCheck(env, negative, s);
            } else {
                Set edges = env.getHypergraph().incident(v);
                boolean exists = false;
                Iterator iter = edges.iterator();
                while (iter.hasNext() && !exists) {
                    Edge e = (Edge)iter.next();
                    Set tmp = Util.union(s, e.getNeighbors(v));
                    boolean bl = exists = exists || this.consistentModelCheck(env, negative, tmp);
                }
                result = exists;
            }
        }
        return result;
    }

    protected List getPositiveLiterals(Conjunction c) {
        List cts = c.getConjuncts();
        List ls = Util.createList();
        int i = 0;
        while (i < cts.size()) {
            if (cts.get(i) instanceof Atom) {
                ls.add(cts.get(i));
            }
            ++i;
        }
        return ls;
    }

    protected List getNegativeLiterals(Conjunction c) {
        List cts = c.getConjuncts();
        List ls = Util.createList();
        int i = 0;
        while (i < cts.size()) {
            if (cts.get(i) instanceof Negation) {
                ls.add(((Negation)cts.get(i)).getNegatedFormula());
            }
            ++i;
        }
        return ls;
    }

    protected List toVertexList(List gs) {
        List vs = Util.createList(gs.size());
        int i = 0;
        while (i < gs.size()) {
            Atom g = (Atom)gs.get(i);
            String name = g.getRelationName();
            Tuple t = g.getValueVector().toTuple();
            vs.add(Vertex.create(name, t));
            ++i;
        }
        return vs;
    }

    protected Set toVertexSet(List gs) {
        return Util.toSet(this.toVertexList(gs));
    }
}

