/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.util;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.util.HashUtil;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Iterator;
import java.util.Map;

public class DataSourceContainer {
    protected Map keys;
    protected Map sources;

    public DataSourceContainer(int rawMaxCapacity) {
        if (rawMaxCapacity <= 0) {
            throw new IllegalArgumentException("rawMaxCapacity must be a positive integer in order to this object work properly.");
        }
        this.keys = Util.createLRUMap(rawMaxCapacity);
        this.sources = Util.createMap();
    }

    public DBKey key(Configuration config) {
        if (!this.keys.containsKey(config)) {
            this.keys.put(config, new DBKey(config));
        }
        return (DBKey)this.keys.get(config);
    }

    public boolean contains(Configuration config) {
        return this.sources.containsKey(this.key(config));
    }

    public DataSource get(Configuration config) {
        return (DataSource)this.sources.get(this.key(config));
    }

    public void remove(Configuration config) {
        this.sources.remove(this.key(config));
    }

    public void put(Configuration config, DataSource source) {
        this.sources.put(this.key(config), source);
    }

    public Iterator iterator() {
        return this.sources.values().iterator();
    }

    protected class DBKey {
        protected Configuration config;
        protected int hashCode;

        public DBKey(Configuration config) {
            this.config = config;
            this.hashCode = HashUtil.hashCodeDB(config);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            boolean result = o instanceof DBKey ? HashUtil.equalDB(this.config, ((DBKey)o).config) : false;
            return result;
        }

        public String toString() {
            return "key:" + this.hashCode;
        }
    }
}

