/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.util;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleMetaData;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import org.apache.log4j.Logger;

public final class FormatUtil {
    private static Logger logger;
    protected static String __buffer;
    protected static int __length;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.util.FormatUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        __buffer = "        ";
        __length = __buffer.length();
    }

    protected static String __format(String str) {
        StringBuffer b = new StringBuffer(__buffer);
        return b.replace(__length - str.length(), __length, str).toString();
    }

    protected static String __fill(char ch) {
        return __buffer.replace(' ', ch);
    }

    public static String txtFormat(TupleStream ts) {
        int fieldCount = ts.getMetaData().getFieldCount();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < fieldCount) {
            result.append(FormatUtil.__format(ts.getMetaData().getFieldName(i)));
            if (i < fieldCount - 1) {
                result.append(" | ");
            } else {
                result.append(" \n");
            }
            ++i;
        }
        i = 0;
        while (i < fieldCount) {
            result.append(FormatUtil.__fill('-'));
            if (i < fieldCount - 1) {
                result.append("-+-");
            } else {
                result.append("-\n");
            }
            ++i;
        }
        int j = 0;
        while (ts.hasNext()) {
            Tuple t = ts.getNext();
            int i2 = 0;
            while (i2 < fieldCount) {
                result.append(FormatUtil.__format("" + t.getObject(i2)));
                if (i2 < fieldCount - 1) {
                    result.append(" | ");
                } else {
                    result.append(" \n");
                }
                ++i2;
            }
            ++j;
        }
        result.append("(").append(j).append(' ');
        result.append(j == 1 ? "tuple" : "tuples").append(")\n\n");
        return result.toString();
    }

    public static String xmlFormat(TupleStream ts, String query) {
        String result = "<tuple-stream>\n";
        if (query != null) {
            result = String.valueOf(result) + "<query>" + FormatUtil.escapeXML(query) + "</query>\n";
        }
        result = String.valueOf(result) + FormatUtil.xmlFormat(ts.getMetaData()) + "\n";
        result = String.valueOf(result) + "<tuples>\n";
        while (ts.hasNext()) {
            result = String.valueOf(result) + FormatUtil.xmlFormat(ts.getNext()) + "\n";
        }
        result = String.valueOf(result) + "</tuples>\n";
        result = String.valueOf(result) + "</tuple-stream>";
        return result;
    }

    public static String xmlFormat(TupleMetaData metaData) {
        String result = "<meta-data>\n";
        int i = 0;
        while (i < metaData.getFieldCount()) {
            result = String.valueOf(result) + "<field  name=\"" + FormatUtil.escapeXML(metaData.getFieldName(i)) + "\" " + " type=\"" + FormatUtil.escapeXML(metaData.getFieldTypeName(i)) + "\"/>";
            ++i;
        }
        result = String.valueOf(result) + "</meta-data>";
        return result;
    }

    public static String xmlFormat(Tuple t) {
        String result = "<tuple>\n";
        int i = 0;
        while (i < t.getFieldCount()) {
            result = String.valueOf(result) + "<field  value=\"" + FormatUtil.escapeXML(t.getObject(i).toString()) + "\"/>";
            ++i;
        }
        result = String.valueOf(result) + "</tuple>";
        return result;
    }

    public static String escapeXML(String string) {
        char[] array = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            switch (array[i]) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '\'': {
                    buffer.append("&apos;");
                    break;
                }
                default: {
                    buffer.append(array[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String escapeSQL(String st) {
        char[] array = st.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            switch (array[i]) {
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case '\'': {
                    buffer.append("\\'");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    buffer.append(array[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String escapeSQLString(String st) {
        return "'" + FormatUtil.escapeSQL(st) + "'";
    }

    public static String parseSQL(String st) {
        char[] array = st.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            block0 : switch (array[i]) {
                case '\\': {
                    switch (array[++i]) {
                        case '\'': {
                            buffer.append('\'');
                            break block0;
                        }
                        case '\"': {
                            buffer.append('\"');
                            break block0;
                        }
                        case 'n': {
                            buffer.append('\n');
                            break block0;
                        }
                        case 'r': {
                            buffer.append('\r');
                            break block0;
                        }
                    }
                    logger.warn((Object)("Unknown escape sequence \\" + array[i] + "."));
                    buffer.append('\'').append(array[i]);
                    break;
                }
                default: {
                    buffer.append(array[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String parseSQLString(String st) {
        return FormatUtil.parseSQL(st.substring(1, st.length() - 1));
    }
}

