/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.util;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.data.config.Bind;
import edu.buffalo.nsf.hippo.data.config.DenialConstraint;
import edu.buffalo.nsf.hippo.data.config.Field;
import edu.buffalo.nsf.hippo.data.config.IntegrityConstraints;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.graph.Edge;
import edu.buffalo.nsf.hippo.data.graph.Vertex;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class HashUtil {
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.util.HashUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return true;
            }
            return o2.equals(o1);
        }
        return o1.equals(o2);
    }

    public static boolean equalEngine(Configuration c1, Configuration c2) {
        return c1 == c2 || HashUtil.equalOrNull(c1.getEngineName(), c2.getEngineName()) && HashUtil.equalOrNull(c1.getProverFactoryName(), c2.getProverFactoryName()) && HashUtil.equalOrNull(c1.getCoreSuffix(), c2.getCoreSuffix()) && HashUtil.equalOrNull(c1.getTranslatorName(), c2.getTranslatorName()) && HashUtil.equalOrNull(c1.getCoreOperatorName(), c2.getCoreOperatorName()) && HashUtil.equalOrNull(c1.getShellOperatorName(), c2.getShellOperatorName()) && HashUtil.equalOrNull(c1.getEnvelopeOperatorName(), c2.getEnvelopeOperatorName());
    }

    public static boolean equalDB(Configuration c1, Configuration c2) {
        return c1 == c2 || HashUtil.equalSchema(c1.getSchema(), c2.getSchema()) && c1.getDBName().equals(c2.getDBName()) && c1.getDBConnectURI().equals(c2.getDBConnectURI()) && c1.getDBUser().equals(c2.getDBUser()) && c1.getDBPassword().equals(c2.getDBPassword()) && c1.getDBDriverName().equals(c2.getDBDriverName()) && HashUtil.equal(c1.getIntegrityConstraints(), c2.getIntegrityConstraints());
    }

    protected static boolean equalSchema(Map schema1, Map schema2) {
        Set keySet = schema1.keySet();
        boolean result = keySet.equals(schema2.keySet());
        Iterator keys = keySet.iterator();
        while (result && keys.hasNext()) {
            Object key = keys.next();
            Relation r1 = (Relation)schema1.get(key);
            Relation r2 = (Relation)schema2.get(key);
            boolean bl = result = result && HashUtil.equal(r1, r2);
        }
        return result;
    }

    protected static boolean equal(Relation r1, Relation r2) {
        boolean result = r1.getName().equals(r2.getName()) && r1.getFieldLength() == r2.getFieldLength();
        int i = 0;
        while (i < r1.getFieldLength()) {
            result = result && HashUtil.equal(r1.getField(i), r2.getField(i));
            ++i;
        }
        return result;
    }

    protected static boolean equal(Field f1, Field f2) {
        return f1.getName().equals(f2.getName()) && f1.getType() == f2.getType();
    }

    protected static boolean equal(IntegrityConstraints ics1, IntegrityConstraints ics2) {
        boolean result = true;
        result = ics1.getIntegrityConstraintLength() == ics2.getIntegrityConstraintLength();
        int i = 0;
        while (result && i < ics1.getIntegrityConstraintLength()) {
            DenialConstraint dc1 = ics1.getIntegrityConstraint(i);
            DenialConstraint dc2 = ics2.getIntegrityConstraint(i);
            result = result && HashUtil.equal(dc1, dc2);
            ++i;
        }
        return result;
    }

    protected static boolean equal(DenialConstraint dc1, DenialConstraint dc2) {
        boolean result = true;
        result = dc1.getBindingLength() == dc2.getBindingLength();
        int i = 0;
        while (result && i < dc1.getBindingLength()) {
            result = result && HashUtil.equal(dc1.getBinding(i), dc2.getBinding(i));
            ++i;
        }
        result = result && dc1.getDefinition().equals(dc2.getDefinition());
        return result;
    }

    protected static boolean equal(Bind b1, Bind b2) {
        return b1.getRelationName().equals(b2.getRelationName()) && b1.getVariableName().equals(b2.getVariableName());
    }

    protected static int hashCode(String s) {
        if (s == null) {
            return 0;
        }
        return s.hashCode();
    }

    public static int hashCode(Configuration config) {
        return HashUtil.hashCode(config.getEngineName()) + HashUtil.hashCode(config.getProverFactoryName()) + HashUtil.hashCode(config.getCoreSuffix()) + HashUtil.hashCode(config.getTranslatorName()) + HashUtil.hashCode(config.getCoreOperatorName()) + HashUtil.hashCode(config.getShellOperatorName()) + HashUtil.hashCode(config.getEnvelopeOperatorName());
    }

    public static int hashCodeDB(Configuration config) {
        int hashCode = 0;
        hashCode += HashUtil.hashCodeSchema(config.getSchema());
        hashCode *= 512;
        hashCode += config.getDBName().hashCode();
        hashCode *= 512;
        hashCode += config.getDBConnectURI().hashCode();
        hashCode *= 512;
        hashCode += config.getDBUser().hashCode();
        hashCode *= 512;
        hashCode += config.getDBPassword().hashCode();
        hashCode *= 512;
        hashCode += config.getDBDriverName().hashCode();
        hashCode *= 512;
        hashCode += HashUtil.hashCode(config.getIntegrityConstraints());
        return hashCode *= 512;
    }

    protected static int hashCodeSchema(Map schema) {
        Iterator keys = schema.keySet().iterator();
        int hashCode = 0;
        while (keys.hasNext()) {
            hashCode += HashUtil.hashCode((Relation)schema.get(keys.next()));
            hashCode *= 32;
        }
        return hashCode;
    }

    protected static int hashCode(Relation r) {
        int hashCode = r.getName().hashCode() * 32;
        int i = 0;
        while (i < r.getFieldLength()) {
            hashCode += HashUtil.hashCode(r.getField(i));
            ++i;
        }
        return hashCode;
    }

    protected static int hashCode(Field f) {
        return f.getName().hashCode() * 32 + f.getType().hashCode();
    }

    protected static int hashCode(IntegrityConstraints ics) {
        int hashCode = 0;
        int i = 0;
        while (i < ics.getIntegrityConstraintLength()) {
            DenialConstraint dc = ics.getIntegrityConstraint(i);
            hashCode += HashUtil.hashCode(dc);
            hashCode *= 64;
            ++i;
        }
        return hashCode;
    }

    protected static int hashCode(DenialConstraint dc) {
        int hashCode = 0;
        int i = 0;
        while (i < dc.getBindingLength()) {
            hashCode += HashUtil.hashCode(dc.getBinding(i));
            hashCode *= 64;
            ++i;
        }
        hashCode += dc.getDefinition().hashCode();
        return hashCode *= 64;
    }

    protected static int hashCode(Bind b) {
        return b.getRelationName().hashCode() * 64 + b.getVariableName().hashCode();
    }

    public static int hashCode(Edge e) {
        return e.getVertices().hashCode();
    }

    public static int hashCode(Vertex v) {
        return v.getRelationName().hashCode() + v.getTuple().hashCode();
    }
}

