/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.util;

import edu.buffalo.nsf.hippo.util.Stats;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Iterator;
import java.util.Map;

public class SimpleStats
extends Stats {
    protected String name;
    protected Map readings;

    public SimpleStats(String name) {
        this.name = name;
        this.readings = Util.createMap();
    }

    public String getName() {
        return this.name;
    }

    public double read(Object category) {
        try {
            return (Double)this.readings.get(category);
        }
        catch (NullPointerException exc) {
            return 0.0;
        }
    }

    public double reset(Object category) {
        double old = this.read(category);
        this.readings.put(category, new Double(0.0));
        return old;
    }

    public double remove(Object category) {
        double old = this.read(category);
        this.readings.remove(category);
        return old;
    }

    public double touch(Object category, double factor) {
        double reading = this.read(category) + factor;
        this.readings.put(category, new Double(reading));
        return reading;
    }

    public Map getReadings() {
        return Util.createMap(this.readings);
    }

    public Iterator getCategories() {
        return this.readings.keySet().iterator();
    }
}

