/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.util;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.EnvironmentImpl;
import edu.buffalo.nsf.hippo.XMLConfiguration;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.util.FormatUtil;
import edu.buffalo.nsf.hippo.util.Util;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public final class StdinClient {
    private static Configuration config;
    private static DataSource source;
    private static Map schema;
    private static Logger logger;
    public static String DEFAULT_CONFIG_FILE;
    public static String DEFAULT_TIME_DIAG_MSG;
    private static String CONFIG_FILE;
    private static String TIME_DIAG_MSG;
    static /* synthetic */ Class class$0;

    static {
        DEFAULT_CONFIG_FILE = "config.xml";
        DEFAULT_TIME_DIAG_MSG = "false";
        CONFIG_FILE = "config-file";
        TIME_DIAG_MSG = "time-diag-msg";
    }

    public static Map parseParams(String[] args) {
        Map params = Util.createMap();
        params.put(CONFIG_FILE, DEFAULT_CONFIG_FILE);
        params.put(TIME_DIAG_MSG, DEFAULT_TIME_DIAG_MSG);
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-c")) {
                if (i + 1 < args.length) {
                    params.put(CONFIG_FILE, args[++i]);
                } else {
                    logger.warn((Object)"the parameter -c should be followed by a full path to a config file \n");
                }
            } else if (args[i].equals("-td")) {
                params.put(TIME_DIAG_MSG, "true");
            } else {
                logger.warn((Object)("Unrecognized option " + args[i] + "... skiping.\n"));
            }
            ++i;
        }
        return params;
    }

    public static void main(String[] args) throws Throwable {
        try {
            Util.setUpLogger();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.util.Test");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger = Logger.getLogger((Class)clazz);
            Map params = StdinClient.parseParams(args);
            String configFile = (String)params.get(CONFIG_FILE);
            boolean timeDiag = params.get(TIME_DIAG_MSG).equals("true");
            EnvironmentImpl env = new EnvironmentImpl();
            XMLConfiguration config = new XMLConfiguration(configFile);
            Engine e = env.getEngine(config);
            String dbName = config.getDBName();
            while (true) {
                int ch;
                System.out.print(String.valueOf(dbName) + "=# ");
                StringBuffer buf = new StringBuffer();
                boolean eof = false;
                do {
                    if ((ch = System.in.read()) == -1) {
                        logger.info((Object)"End of input received.");
                        System.out.println();
                        eof = true;
                        break;
                    }
                    buf.append((char)ch);
                } while (ch != 59);
                if (eof) break;
                String query = buf.toString().trim();
                logger.info((Object)("The query: " + query));
                Date start = new Date();
                try {
                    TupleStream ts = e.getConsistentAnswer(query);
                    System.out.print(FormatUtil.txtFormat(ts));
                    logger.info((Object)ts);
                    Date stop = new Date();
                    Date rt = new Date(stop.getTime() - start.getTime());
                    SimpleDateFormat f = new SimpleDateFormat("m:ss.SSS");
                    if (!timeDiag) continue;
                    logger.warn((Object)("Time elapsed: " + f.format(rt) + "\n"));
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                    logger.error((Object)exc);
                }
            }
            env.dispose(e);
            env.shutdown();
        }
        catch (Throwable t) {
            logger.fatal((Object)"Exception thrown.", t);
            throw t;
        }
    }
}

