/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.data.config.Config;
import edu.buffalo.nsf.hippo.data.config.ConnectionParams;
import edu.buffalo.nsf.hippo.data.config.DataSourceParams;
import edu.buffalo.nsf.hippo.data.config.DbDescription;
import edu.buffalo.nsf.hippo.data.config.Engine;
import edu.buffalo.nsf.hippo.data.config.EngineDescription;
import edu.buffalo.nsf.hippo.data.config.IntegrityConstraints;
import edu.buffalo.nsf.hippo.data.config.ProverFactory;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.config.ResultInterpretation;
import edu.buffalo.nsf.hippo.data.config.ResultMap;
import edu.buffalo.nsf.hippo.data.config.Schema;
import edu.buffalo.nsf.hippo.prolog.Elaboration;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfigConfiguration
implements Configuration {
    protected static Logger logger;
    protected String sourceName;
    protected boolean isCached;
    protected int cacheSize;
    protected Map schema;
    protected String dbName;
    protected String driverName;
    protected String connectURI;
    protected String user;
    protected String password;
    protected IntegrityConstraints ics;
    protected String engineName;
    protected String factoryName;
    protected Map ri;
    protected String coreSuffix;
    protected String translatorName;
    protected String coreOperatorName;
    protected String shellOperatorName;
    protected String envelopeOperatorName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.ConfigConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    protected static String getDataSourceName(Config config) {
        DbDescription db = config.getDbDescription();
        DataSourceParams dsp = db.getDataSourceParams();
        return dsp.getName();
    }

    protected static boolean isCached(Config config) {
        try {
            DbDescription db = config.getDbDescription();
            DataSourceParams dsp = db.getDataSourceParams();
            return dsp.isCached();
        }
        catch (NullPointerException exc) {
            return false;
        }
    }

    protected static int getCacheSize(Config config) {
        try {
            DbDescription db = config.getDbDescription();
            DataSourceParams dsp = db.getDataSourceParams();
            return dsp.getCacheSize();
        }
        catch (NullPointerException exc) {
            return 0;
        }
    }

    protected static Map getSchema(Config config) {
        Map result = Util.createMap();
        try {
            DbDescription db = config.getDbDescription();
            Schema schema = db.getSchema();
            Relation[] rel = schema.getRelation();
            int i = 0;
            while (i < rel.length) {
                result.put(rel[i].getName(), rel[i]);
                ++i;
            }
            return result;
        }
        catch (NullPointerException exc) {
            logger.error((Object)"Can not access schema data from the configuration");
            logger.error((Object)("Reason:" + exc));
            return result;
        }
    }

    protected static String getDriverName(Config config) {
        DbDescription db = config.getDbDescription();
        ConnectionParams params = db.getConnectionParams();
        return params.getDriverName();
    }

    protected static String getConnectURI(Config config) {
        DbDescription db = config.getDbDescription();
        ConnectionParams params = db.getConnectionParams();
        String dbName = params.getDbName();
        String host = params.getHost();
        int port = params.getPort();
        String result = "jdbc:postgresql:";
        if (host != null) {
            result = String.valueOf(result) + "//" + host;
            if (port != 0) {
                result = String.valueOf(result) + ":" + port;
            }
            result = String.valueOf(result) + "/";
        }
        return String.valueOf(result) + dbName;
    }

    protected static String getDBName(Config config) {
        DbDescription db = config.getDbDescription();
        ConnectionParams params = db.getConnectionParams();
        String dbName = params.getDbName();
        return dbName;
    }

    protected static String getUser(Config config) {
        DbDescription db = config.getDbDescription();
        ConnectionParams params = db.getConnectionParams();
        return params.getUser();
    }

    protected static String getPassword(Config config) {
        DbDescription db = config.getDbDescription();
        ConnectionParams params = db.getConnectionParams();
        return params.getPassword();
    }

    protected static IntegrityConstraints getIntegrityConstraints(Config config) {
        return config.getDbDescription().getIntegrityConstraints();
    }

    protected static String getProverFactoryName(Config config) {
        EngineDescription edsc = config.getEngineDescription();
        Engine e = edsc.getEngine();
        ProverFactory p = e.getProverFactory();
        if (p == null) {
            return null;
        }
        String proverName = p.getName();
        return proverName;
    }

    protected static String getEngineName(Config config) {
        EngineDescription edsc = config.getEngineDescription();
        Engine e = edsc.getEngine();
        return e.getName();
    }

    protected static Map getResultInterpretation(Config config) {
        Map ri = Util.createMap();
        EngineDescription edsc = config.getEngineDescription();
        Engine e = edsc.getEngine();
        ResultInterpretation r = e.getResultInterpretation();
        if (r == null) {
            return null;
        }
        int i = 0;
        while (i < r.getResultMapLength()) {
            ResultMap map = r.getResultMap(i);
            Elaboration key = Elaboration.create(map.getValue());
            Boolean value = new Boolean(map.isAccepted());
            ri.put(key, value);
            ++i;
        }
        return ri;
    }

    protected static String getCoreSuffix(Config config) {
        EngineDescription edsc = config.getEngineDescription();
        Engine e = edsc.getEngine();
        return e.getCoreSuffix();
    }

    protected static String getTranslatorName(Config config) {
        EngineDescription edsc = config.getEngineDescription();
        Engine e = edsc.getEngine();
        return e.getTranslatorName();
    }

    protected static String getCoreOperatorName(Config config) {
        EngineDescription edsc = config.getEngineDescription();
        Engine e = edsc.getEngine();
        return e.getCoreOperatorName();
    }

    protected static String getShellOperatorName(Config config) {
        EngineDescription edsc = config.getEngineDescription();
        Engine e = edsc.getEngine();
        return e.getShellOperatorName();
    }

    protected static String getEnvelopeOperatorName(Config config) {
        EngineDescription edsc = config.getEngineDescription();
        Engine e = edsc.getEngine();
        return e.getEnvelopeOperatorName();
    }

    public ConfigConfiguration(Config config) {
        this.sourceName = ConfigConfiguration.getDataSourceName(config);
        this.isCached = ConfigConfiguration.isCached(config);
        this.cacheSize = ConfigConfiguration.getCacheSize(config);
        this.schema = ConfigConfiguration.getSchema(config);
        this.dbName = ConfigConfiguration.getDBName(config);
        this.driverName = ConfigConfiguration.getDriverName(config);
        this.connectURI = ConfigConfiguration.getConnectURI(config);
        this.user = ConfigConfiguration.getUser(config);
        this.password = ConfigConfiguration.getPassword(config);
        this.ics = ConfigConfiguration.getIntegrityConstraints(config);
        this.engineName = ConfigConfiguration.getEngineName(config);
        this.factoryName = ConfigConfiguration.getProverFactoryName(config);
        this.ri = ConfigConfiguration.getResultInterpretation(config);
        this.coreSuffix = ConfigConfiguration.getCoreSuffix(config);
        this.translatorName = ConfigConfiguration.getTranslatorName(config);
        this.coreOperatorName = ConfigConfiguration.getCoreOperatorName(config);
        this.shellOperatorName = ConfigConfiguration.getShellOperatorName(config);
        this.envelopeOperatorName = ConfigConfiguration.getEnvelopeOperatorName(config);
    }

    public String getDataSourceName() {
        return this.sourceName;
    }

    public boolean isDataSourceCached() {
        return this.isCached;
    }

    public int getDataSourceCacheSize() {
        return this.cacheSize;
    }

    public Map getSchema() {
        return this.schema;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getDBConnectURI() {
        return this.connectURI;
    }

    public String getDBUser() {
        return this.user;
    }

    public String getDBPassword() {
        return this.password;
    }

    public String getDBDriverName() {
        return this.driverName;
    }

    public IntegrityConstraints getIntegrityConstraints() {
        return this.ics;
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public String getProverFactoryName() {
        return this.factoryName;
    }

    public String getCoreSuffix() {
        return this.coreSuffix;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public Map getResultInterpretation() {
        return this.ri;
    }

    public String getCoreOperatorName() {
        return this.coreOperatorName;
    }

    public String getShellOperatorName() {
        return this.shellOperatorName;
    }

    public String getEnvelopeOperatorName() {
        return this.envelopeOperatorName;
    }
}

