/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.DataSourceError;
import edu.buffalo.nsf.hippo.data.config.Bind;
import edu.buffalo.nsf.hippo.data.config.DenialConstraint;
import edu.buffalo.nsf.hippo.data.config.Field;
import edu.buffalo.nsf.hippo.data.config.IntegrityConstraints;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.graph.Edge;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;
import edu.buffalo.nsf.hippo.data.graph.InternalHypergraphImpl;
import edu.buffalo.nsf.hippo.data.graph.Vertex;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.util.FormatUtil;
import edu.buffalo.nsf.hippo.util.Util;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SQLDataSource
implements DataSource {
    private static Logger logger;
    protected Environment env;
    protected Connection db;
    protected Map schema;
    protected IntegrityConstraints ics;
    protected Hypergraph h;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.data.SQLDataSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public SQLDataSource(Environment env) {
        this.env = env;
    }

    public void init(Configuration config) {
        this.schema = config.getSchema();
        this.db = this.env.getConnection(config);
        this.ics = config.getIntegrityConstraints();
    }

    public void shutdown() {
        this.env.release(this.db);
        this.h = null;
    }

    protected TupleStream executeSQLQuery(String sqlQuery) {
        try {
            Statement stmt = this.db.createStatement();
            ResultSet rs = stmt.executeQuery(sqlQuery);
            TupleStream result = TupleStream.create(rs, stmt);
            return result;
        }
        catch (SQLException exc) {
            logger.error((Object)("Exception caught while executing the query: " + sqlQuery), (Throwable)exc);
            throw new DataSourceError("SQLException caught", exc);
        }
    }

    public TupleStream executeQuery(Query query) {
        return this.executeSQLQuery(query.toString());
    }

    protected TupleStream detectConflicts(DenialConstraint dc) {
        String sqlQuery = "SELECT * FROM ";
        Bind[] b = dc.getBinding();
        if (b == null || b.length == 0) {
            logger.warn((Object)"Constraint with no bindings.");
            return TupleStream.EMPTY_TUPLE_STREAM;
        }
        int i = 0;
        while (i < b.length) {
            sqlQuery = String.valueOf(sqlQuery) + b[i].getRelationName() + " " + b[i].getVariableName();
            if (i < b.length - 1) {
                sqlQuery = String.valueOf(sqlQuery) + ", ";
            }
            ++i;
        }
        sqlQuery = String.valueOf(sqlQuery) + " ";
        sqlQuery = String.valueOf(sqlQuery) + "WHERE NOT (" + dc.getDefinition() + ")";
        return this.executeSQLQuery(sqlQuery);
    }

    protected Hypergraph _getHypergraph() {
        logger.debug((Object)"Creating hypergraph!");
        DenialConstraint[] dc = this.ics.getIntegrityConstraint();
        Set edges = Util.createSet();
        int i = 0;
        while (i < dc.length) {
            TupleStream ts = this.detectConflicts(dc[i]);
            while (ts.hasNext()) {
                edges.add(Edge.create(dc[i], this.schema, ts.getNext()));
            }
            ++i;
        }
        InternalHypergraphImpl h = new InternalHypergraphImpl(edges);
        return h;
    }

    public synchronized Hypergraph getHypergraph() {
        if (this.h == null) {
            this.h = this._getHypergraph();
        }
        return this.h;
    }

    public boolean checkVertex(Vertex v) {
        String relName = v.getRelationName();
        Tuple t = v.getTuple();
        Relation r = (Relation)this.schema.get(relName);
        String query = "SELECT COUNT(*) FROM " + relName + " WHERE ";
        if (r == null) {
            logger.warn((Object)("Trying to check tuple of relation " + relName + " " + "not contained in schema data."));
            return false;
        }
        Field[] f = r.getField();
        int i = 0;
        while (i < f.length) {
            if (t.getObject(i) != null) {
                query = String.valueOf(query) + relName + "." + f[i].getName() + " = ";
                query = t.getObject(i) instanceof String ? String.valueOf(query) + FormatUtil.escapeSQLString(t.getObject(i).toString()) : String.valueOf(query) + t.getObject(i).toString();
            } else {
                query = String.valueOf(query) + relName + "." + f[i].getName() + " is NULL";
            }
            if (i < f.length - 1) {
                query = String.valueOf(query) + " AND ";
            }
            ++i;
        }
        TupleStream ts = this.executeSQLQuery(query);
        if (!ts.hasNext()) {
            throw new InternalError("Inappropriate SQL backend behavior.");
        }
        return ts.getNext().getInt(0) != 0;
    }
}

