/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.formula;

import edu.buffalo.nsf.hippo.data.formula.Comparator;
import edu.buffalo.nsf.hippo.data.formula.Constant;
import edu.buffalo.nsf.hippo.data.formula.Formula;
import edu.buffalo.nsf.hippo.data.formula.Value;
import java.util.Map;

public class Comparison
extends Formula {
    protected Value val1;
    protected Comparator comp;
    protected Value val2;

    protected Comparison(Value val1, Comparator comp, Value val2) {
        this.val1 = val1;
        this.comp = comp;
        this.val2 = val2;
    }

    public static Formula create(Value val1, Comparator comp, Value val2) {
        return new Comparison(val1, comp, val2);
    }

    public Formula substitute(Map s) {
        Value v1 = this.val1.substitute(s);
        Value v2 = this.val2.substitute(s);
        if (v1.isGround() && v2.isGround()) {
            Comparable c2;
            Comparable c1 = (Comparable)((Constant)v1).getValue();
            if (this.comp.compare(c1, c2 = (Comparable)((Constant)v2).getValue())) {
                return Formula.TRUE;
            }
            return Formula.FALSE;
        }
        return Comparison.create(v1, this.comp, v2);
    }

    public String toString() {
        return this.val1 + " " + this.comp + " " + this.val2;
    }
}

