/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.formula;

import edu.buffalo.nsf.hippo.data.formula.Conjunction;
import edu.buffalo.nsf.hippo.data.formula.Formula;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.List;
import java.util.Map;

public class Disjunction
extends Formula {
    protected List l;

    public static Formula create(Formula expr) {
        List l = Util.createList(1);
        l.add(expr);
        return Disjunction.create(l);
    }

    public static Formula create(Formula expr1, Formula expr2) {
        List l = Util.createList(2);
        l.add(expr1);
        l.add(expr2);
        return Disjunction.create(l);
    }

    public static Formula create(List l) {
        List l2 = Util.createList(l.size());
        int i = 0;
        while (i < l.size()) {
            Formula f = (Formula)l.get(i);
            if (f == null) {
                throw new IllegalArgumentException("Null argument.");
            }
            if (f == Formula.TRUE) {
                return Formula.TRUE;
            }
            if (f != Formula.FALSE) {
                l2.add(f);
            }
            ++i;
        }
        if (l2.isEmpty()) {
            return Formula.FALSE;
        }
        return new Disjunction(l2);
    }

    protected Disjunction(List l) {
        this.l = l;
    }

    public Formula substitute(Map substitution) {
        List tmp = Util.createList();
        int i = 0;
        while (i < this.l.size()) {
            Formula f = (Formula)this.l.get(i);
            Formula g = f.substitute(substitution);
            tmp.add(g);
            ++i;
        }
        return Disjunction.create(tmp);
    }

    protected Formula pushDownNegations(boolean negationCarry) {
        List tmp = Util.createList();
        int i = 0;
        while (i < this.l.size()) {
            tmp.add(((Formula)this.l.get(i)).pushDownNegations(negationCarry));
            ++i;
        }
        if (negationCarry) {
            return Conjunction.create(tmp);
        }
        return Disjunction.create(tmp);
    }

    protected Formula pushDownDisjunctions() {
        this.normalize();
        int i = 0;
        while (i < this.l.size()) {
            ((Formula)this.l.get(i)).pushDownDisjunctions();
            ++i;
        }
        Conjunction conj = null;
        int i2 = 0;
        while (i2 < this.l.size()) {
            if (this.l.get(i2) instanceof Conjunction) {
                conj = (Conjunction)this.l.remove(i2);
                break;
            }
            ++i2;
        }
        if (conj == null) {
            return this;
        }
        List c = conj.l;
        List result = Util.createList();
        int i3 = 0;
        while (i3 < c.size()) {
            Formula f = (Formula)c.get(i3);
            List tmp = Util.createList();
            tmp.addAll(this.l);
            tmp.add(f);
            result.add(Disjunction.create(tmp).pushDownDisjunctions());
            ++i3;
        }
        return Conjunction.create(result);
    }

    public void normalize() {
        int i = 0;
        while (i < this.l.size()) {
            Formula f = (Formula)this.l.get(i);
            f.normalize();
            if (f instanceof Disjunction) {
                Disjunction d = (Disjunction)this.l.remove(i);
                this.l.addAll(d.l);
                continue;
            }
            ++i;
        }
    }

    public String toString() {
        if (this.l.isEmpty()) {
            return "FALSE";
        }
        String result = new String();
        int i = 0;
        while (i < this.l.size()) {
            result = String.valueOf(result) + "(" + this.l.get(i).toString() + ")";
            if (i < this.l.size() - 1) {
                result = String.valueOf(result) + " OR ";
            }
            ++i;
        }
        return result;
    }

    public List getDisjuncts() {
        return this.l;
    }
}

