/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.formula;

import edu.buffalo.nsf.hippo.data.formula.Constant;
import edu.buffalo.nsf.hippo.data.formula.Value;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import java.util.Arrays;
import java.util.Map;

public class ValueVector {
    protected Value[] val;

    public ValueVector(Value[] val) {
        this.val = val;
    }

    public boolean isGround() {
        int i = 0;
        while (i < this.val.length) {
            if (!this.val[i].isGround()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ValueVector substitute(Map s) {
        Value[] t = new Value[this.val.length];
        int i = 0;
        while (i < this.val.length) {
            t[i] = this.val[i].substitute(s);
            ++i;
        }
        return new ValueVector(t);
    }

    public Tuple toTuple() {
        if (!this.isGround()) {
            throw new IllegalStateException("ValueVector not ground.");
        }
        Object[] v = new Object[this.val.length];
        int i = 0;
        while (i < v.length) {
            v[i] = ((Constant)this.val[i]).getValue();
            ++i;
        }
        return Tuple.create(v);
    }

    public String toString() {
        return Arrays.asList(this.val).toString();
    }
}

