/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.query.traverse;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.FromSubquery;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Intersection;
import edu.buffalo.nsf.hippo.data.query.OuterJoin;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.Select;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.Union;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTransformer;
import edu.buffalo.nsf.hippo.data.query.traverse.UniformTransformer;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExtendedFOperator
implements QueryTransformer {
    protected Logger logger;
    protected QueryTransformer f;
    protected QueryTransformer u;
    protected Environment env;
    protected Map schema;
    protected String coreSuffix;
    static /* synthetic */ Class class$0;

    public ExtendedFOperator(Environment env) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.data.query.traverse.ExtendedFOperator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = Logger.getLogger((Class)clazz);
        this.env = env;
        this.u = new UniformTransformer(env);
    }

    public void init(Configuration config) {
        this.schema = config.getSchema();
        this.coreSuffix = config.getCoreSuffix();
        this.f = this.env.getShellOperator(config);
        this.u.init(config);
    }

    public void shutdown() {
        this.u.shutdown();
        this.env.dispose(this.f);
    }

    protected Relation getRelation(String relName) {
        if (relName.endsWith(this.coreSuffix)) {
            relName = relName.substring(0, relName.length() - this.coreSuffix.length());
        }
        return (Relation)this.schema.get(relName);
    }

    public Query transform(Query q) {
        List skg = this.findSKG(q);
        this.logger.debug((Object)("This is skg:" + skg));
        List stc = this.findSTC(q);
        this.logger.debug((Object)("This is stc:" + stc));
        RI[] ri = this.getGamma(skg, stc);
        Relation[] r = new Relation[ri.length];
        int[] offset = new int[ri.length];
        int i = 0;
        while (i < ri.length) {
            r[i] = this.getRelation(ri[i].rel);
            offset[i] = ri[i].attr;
            ++i;
        }
        if (r.length > 0) {
            return new OuterJoin(this.u.transform(this.f.transform(q)), stc.size(), r, offset);
        }
        return this.f.transform(q);
    }

    protected RI[] getGamma(List skg, List stc) {
        List gamma = Util.createList();
        List c = Util.createList();
        int i = 0;
        while (i < skg.size()) {
            ((Set)stc.get(i)).removeAll((Set)skg.get(i));
            c.add(stc.get(i));
            ++i;
        }
        i = 0;
        while (i < c.size()) {
            Iterator s = ((Set)c.get(i)).iterator();
            while (s.hasNext()) {
                RI o = (RI)s.next();
                if (o.attr != 0) continue;
                gamma.add(new RI(o.rel, i));
            }
            ++i;
        }
        return gamma.toArray(new RI[0]);
    }

    protected List findSKG(Query q) {
        if (q instanceof Select) {
            Select s = (Select)q;
            return this.findSKGSelect(s.getSelectList(), s.getFromList(), s.getWhereCondition(), s.getGroupByList());
        }
        if (q instanceof Difference) {
            Difference d = (Difference)q;
            return this.findSKGDifference(d.getExpr1(), d.getExpr2());
        }
        if (q instanceof Intersection) {
            Intersection i = (Intersection)q;
            return this.findSKGIntersection(i.getExpr1(), i.getExpr1());
        }
        if (q instanceof Union) {
            Union u = (Union)q;
            return this.findSKGUnion(u.getExpr1(), u.getExpr2());
        }
        throw new IllegalArgumentException("Unknown Query subclass.");
    }

    protected List findSKG(FromExpr fromExpr) {
        if (fromExpr instanceof FromRelation) {
            FromRelation r = (FromRelation)fromExpr;
            return this.findSKGFromRelation(r.getRelationName(), r.getBindingName());
        }
        if (fromExpr instanceof FromSubquery) {
            FromSubquery s = (FromSubquery)fromExpr;
            return this.findSKGFromSubquery(s.getSubquery(), s.getBindingName());
        }
        throw new IllegalArgumentException("Unknown FromExpr subclass.");
    }

    protected List findSKGSelect(SelectList selectList, FromList fromList, WhereCondition whereCondition, GroupByList groupByList) {
        if (groupByList != null) {
            throw new IllegalArgumentException("This translator can be used only for SJUID queires.");
        }
        return this.findSKGFromList(fromList.getFromExpr());
    }

    protected List findSKGFromList(FromExpr[] fromExpr) {
        List res = Util.createList();
        int i = 0;
        while (i < fromExpr.length) {
            res.addAll(this.findSKG(fromExpr[i]));
            ++i;
        }
        return res;
    }

    protected List findSKGFromRelation(String relName, String bindName) {
        Relation r = this.getRelation(relName);
        List res = Util.createList();
        int i = 0;
        while (i < r.getFieldLength()) {
            Set s = Util.createSet();
            s.add(new RI(relName, i));
            res.add(s);
            ++i;
        }
        return res;
    }

    protected List findSKGFromSubquery(Query q, String bindName) {
        return this.findSKG(q);
    }

    protected List findSKGDifference(Query expr1, Query expr2) {
        return this.findSKG(expr1);
    }

    protected List findSKGIntersection(Query expr1, Query expr2) {
        List skg1 = this.findSKG(expr1);
        List skg2 = this.findSKG(expr2);
        List skg = Util.createList();
        int i = 0;
        while (i < skg1.size()) {
            skg.add(Util.union((Set)skg1.get(i), (Set)skg2.get(i)));
            ++i;
        }
        return skg;
    }

    protected List findSKGUnion(Query expr1, Query expr2) {
        List skg1 = this.findSKG(expr1);
        List skg2 = this.findSKG(expr2);
        List skg = Util.createList();
        int i = 0;
        while (i < skg1.size()) {
            skg.add(Util.cut((Set)skg1.get(i), (Set)skg2.get(i)));
            ++i;
        }
        return skg;
    }

    public List findSTC(Query q) {
        if (q instanceof Select) {
            Select s = (Select)q;
            return this.findSTCSelect(s.getSelectList(), s.getFromList(), s.getWhereCondition(), s.getGroupByList());
        }
        if (q instanceof Difference) {
            Difference d = (Difference)q;
            return this.findSTCDifference(d.getExpr1(), d.getExpr2());
        }
        if (q instanceof Intersection) {
            Intersection i = (Intersection)q;
            return this.findSTCIntersection(i.getExpr1(), i.getExpr1());
        }
        if (q instanceof Union) {
            Union u = (Union)q;
            return this.findSTCUnion(u.getExpr1(), u.getExpr2());
        }
        throw new IllegalArgumentException("Unknown Query subclass.");
    }

    protected List findSTC(FromExpr fromExpr) {
        if (fromExpr instanceof FromRelation) {
            FromRelation r = (FromRelation)fromExpr;
            return this.findSTCFromRelation(r.getRelationName(), r.getBindingName());
        }
        if (fromExpr instanceof FromSubquery) {
            FromSubquery s = (FromSubquery)fromExpr;
            return this.findSTCFromSubquery(s.getSubquery(), s.getBindingName());
        }
        throw new IllegalArgumentException("Unknown FromExpr subclass.");
    }

    protected List findSTCSelect(SelectList selectList, FromList fromList, WhereCondition whereCondition, GroupByList groupByList) {
        if (groupByList != null) {
            throw new IllegalArgumentException("This translator can be used only for SJUID queires.");
        }
        return this.findSTCFromList(fromList.getFromExpr());
    }

    protected List findSTCFromList(FromExpr[] fromExpr) {
        List res = Util.createList();
        int i = 0;
        while (i < fromExpr.length) {
            res.addAll(this.findSTC(fromExpr[i]));
            ++i;
        }
        return res;
    }

    protected List findSTCFromRelation(String relName, String bindName) {
        Relation r = this.getRelation(relName);
        List res = Util.createList();
        int i = 0;
        while (i < r.getFieldLength()) {
            Set s = Util.createSet();
            s.add(new RI(relName, i));
            res.add(s);
            ++i;
        }
        return res;
    }

    protected List findSTCFromSubquery(Query q, String bindName) {
        return this.findSTC(q);
    }

    protected List findSTCDifference(Query expr1, Query expr2) {
        List skg1 = this.findSTC(expr1);
        List skg2 = this.findSTC(expr2);
        List skg = Util.createList();
        int i = 0;
        while (i < skg1.size()) {
            skg.add(Util.union((Set)skg1.get(i), (Set)skg2.get(i)));
            ++i;
        }
        return skg;
    }

    protected List findSTCIntersection(Query expr1, Query expr2) {
        List skg1 = this.findSTC(expr1);
        List skg2 = this.findSTC(expr2);
        List skg = Util.createList();
        int i = 0;
        while (i < skg1.size()) {
            skg.add(Util.union((Set)skg1.get(i), (Set)skg2.get(i)));
            ++i;
        }
        return skg;
    }

    protected List findSTCUnion(Query expr1, Query expr2) {
        List skg1 = this.findSTC(expr1);
        List skg2 = this.findSTC(expr2);
        List skg = Util.createList();
        int i = 0;
        while (i < skg1.size()) {
            skg.add(Util.union((Set)skg1.get(i), (Set)skg2.get(i)));
            ++i;
        }
        return skg;
    }

    protected class RI {
        public String rel;
        public int attr;

        public RI(String rel, int attr) {
            this.rel = rel;
            this.attr = attr;
        }

        public boolean equals(Object o) {
            return this.equal(this, (RI)o);
        }

        public boolean equal(RI o1, RI o2) {
            return o1.rel.equals(o2.rel) && o1.attr == o2.attr;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return String.valueOf(this.rel) + "_" + this.attr;
        }
    }
}

