/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.query.traverse;

import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.formula.Value;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.FromSubquery;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Intersection;
import edu.buffalo.nsf.hippo.data.query.OuterJoin;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.Select;
import edu.buffalo.nsf.hippo.data.query.SelectConstant;
import edu.buffalo.nsf.hippo.data.query.SelectExpr;
import edu.buffalo.nsf.hippo.data.query.SelectField;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.Union;
import edu.buffalo.nsf.hippo.data.query.WhereCompValue;
import edu.buffalo.nsf.hippo.data.query.WhereComparator;
import edu.buffalo.nsf.hippo.data.query.WhereComparison;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.data.query.WhereConjunction;
import edu.buffalo.nsf.hippo.data.query.WhereConstant;
import edu.buffalo.nsf.hippo.data.query.WhereDisjunction;
import edu.buffalo.nsf.hippo.data.query.WhereNegation;
import edu.buffalo.nsf.hippo.data.query.WhereSelectValue;

public abstract class QueryWalker {
    protected void traverse(Query q) {
        if (q instanceof Select) {
            Select s = (Select)q;
            this.traverseSelect(s.getSelectList(), s.getFromList(), s.getWhereCondition(), s.getGroupByList());
        } else if (q instanceof Difference) {
            Difference d = (Difference)q;
            this.traverseDifference(d.getExpr1(), d.getExpr2());
        } else if (q instanceof Intersection) {
            Intersection i = (Intersection)q;
            this.traverseIntersection(i.getExpr1(), i.getExpr1());
        } else if (q instanceof Union) {
            Union u = (Union)q;
            this.traverseUnion(u.getExpr1(), u.getExpr2());
        } else if (q instanceof OuterJoin) {
            OuterJoin o = (OuterJoin)q;
            this.traverseOuterJoin(o.query, o.length, o.rel, o.offset);
        } else {
            throw new IllegalArgumentException("Unknown Query subclass.");
        }
    }

    protected void traverseOuterJoin(Query q, int length, Relation[] rel, int[] offset) {
    }

    protected void traverse(SelectExpr selectExpr) {
        if (selectExpr instanceof SelectConstant) {
            SelectConstant c = (SelectConstant)selectExpr;
            this.traverseSelectConstant(c.getConstant());
        } else if (selectExpr instanceof SelectField) {
            SelectField f = (SelectField)selectExpr;
            this.traverseSelectField(f.getBindingName(), f.getFieldName());
        } else {
            throw new IllegalArgumentException("Unknown SelectExpr subclass.");
        }
    }

    protected void traverse(FromExpr fromExpr) {
        if (fromExpr instanceof FromRelation) {
            FromRelation r = (FromRelation)fromExpr;
            this.traverseFromRelation(r.getRelationName(), r.getBindingName());
        } else if (fromExpr instanceof FromSubquery) {
            FromSubquery s = (FromSubquery)fromExpr;
            this.traverseFromSubquery(s.getSubquery(), s.getBindingName());
        } else {
            throw new IllegalArgumentException("Unknown FromExpr subclass.");
        }
    }

    protected void traverse(WhereCondition whereCondition) {
        if (whereCondition instanceof WhereComparison) {
            WhereComparison cmp = (WhereComparison)whereCondition;
            this.traverseWhereComparison(cmp.getComparedValue1(), cmp.getComparator(), cmp.getComparedValue2());
        } else if (whereCondition instanceof WhereConjunction) {
            WhereConjunction c = (WhereConjunction)whereCondition;
            this.traverseWhereConjunction(c.getCondition1(), c.getCondition2());
        } else if (whereCondition instanceof WhereDisjunction) {
            WhereDisjunction d = (WhereDisjunction)whereCondition;
            this.traverseWhereDisjunction(d.getCondition1(), d.getCondition2());
        } else if (whereCondition instanceof WhereNegation) {
            WhereNegation n = (WhereNegation)whereCondition;
            this.traverseWhereNegation(n.getCondition());
        } else {
            throw new IllegalArgumentException("Unknown WhereCondition subclass.");
        }
    }

    protected Value traverse(WhereCompValue val) {
        if (val instanceof WhereSelectValue) {
            WhereSelectValue s = (WhereSelectValue)val;
            return this.traverseWhereSelectValue(s.getBindingName(), s.getFieldName());
        }
        if (val instanceof WhereConstant) {
            WhereConstant c = (WhereConstant)val;
            return this.traverseWhereConstant(c.getConstant());
        }
        throw new IllegalArgumentException("Unknown WhereCompValue subclass.");
    }

    protected abstract void traverseSelect(SelectList var1, FromList var2, WhereCondition var3, GroupByList var4);

    protected abstract void traverseSelectList(SelectExpr[] var1);

    protected abstract void traverseSelectConstant(Object var1);

    protected abstract void traverseSelectField(String var1, String var2);

    protected abstract void traverseFromList(FromExpr[] var1);

    protected abstract void traverseFromRelation(String var1, String var2);

    protected abstract void traverseFromSubquery(Query var1, String var2);

    protected abstract void traverseWhereComparison(WhereCompValue var1, WhereComparator var2, WhereCompValue var3);

    protected abstract void traverseWhereConjunction(WhereCondition var1, WhereCondition var2);

    protected abstract void traverseWhereDisjunction(WhereCondition var1, WhereCondition var2);

    protected abstract void traverseWhereNegation(WhereCondition var1);

    protected abstract Value traverseWhereSelectValue(String var1, String var2);

    protected abstract Value traverseWhereConstant(Object var1);

    protected abstract void traverseDifference(Query var1, Query var2);

    protected abstract void traverseIntersection(Query var1, Query var2);

    protected abstract void traverseUnion(Query var1, Query var2);
}

