/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.query.traverse;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.InternalProblem;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.formula.Atom;
import edu.buffalo.nsf.hippo.data.formula.Comparator;
import edu.buffalo.nsf.hippo.data.formula.Comparison;
import edu.buffalo.nsf.hippo.data.formula.Constant;
import edu.buffalo.nsf.hippo.data.formula.Formula;
import edu.buffalo.nsf.hippo.data.formula.Value;
import edu.buffalo.nsf.hippo.data.formula.Variable;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.SelectExpr;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.WhereCompValue;
import edu.buffalo.nsf.hippo.data.query.WhereComparator;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.data.query.traverse.BindingStack;
import edu.buffalo.nsf.hippo.data.query.traverse.FormulaStack;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTranslator;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Map;

public class SJUIDTranslator
extends QueryTranslator {
    protected Map schema;
    protected FormulaStack f;
    protected BindingStack b;
    protected int varIndex;
    protected static final String VAR_PREFIX = "X_";

    public SJUIDTranslator(Environment env) {
    }

    public void init(Configuration config) {
        this.schema = config.getSchema();
        this.f = new FormulaStack();
        this.b = new BindingStack();
    }

    public void shutdown() {
    }

    public static Map createSubstitution(Tuple t) {
        Map s = Util.createMap();
        int i = 0;
        while (i < t.getFieldCount()) {
            s.put(VAR_PREFIX + i, Constant.create(t.getObject(i)));
            ++i;
        }
        return s;
    }

    public Formula translate(Query q) {
        try {
            this.varIndex = 0;
            this.f.push(Formula.TRUE);
            this.traverse(q);
            return this.f.pop();
        }
        catch (Error err) {
            this.f.clear();
            this.b.clear();
            throw err;
        }
        catch (RuntimeException exc) {
            this.f.clear();
            this.b.clear();
            throw exc;
        }
    }

    protected void traverseOuterJoin(Query q, int length, Relation[] rel, int[] offset) {
        this.traverse(q);
    }

    protected void traverseSelect(SelectList selectList, FromList fromList, WhereCondition whereCondition, GroupByList groupByList) {
        this.traverseSelectList(selectList.getSelectExpr());
        this.traverseFromList(fromList.getFromExpr());
        if (whereCondition != null) {
            this.traverse(whereCondition);
        }
        int i = 0;
        while (i < fromList.getFromExpr().length) {
            if (fromList.getFromExpr()[i] instanceof FromRelation) {
                this.b.pop();
            }
            ++i;
        }
        if (groupByList != null) {
            throw new IllegalArgumentException("This translator can be used only for SJUID queires.");
        }
    }

    protected void traverseSelectList(SelectExpr[] selectExpr) {
        if (selectExpr.length != 1 || selectExpr[0] != SelectExpr.STAR) {
            throw new IllegalArgumentException("This translator can be used only for projection free queries.");
        }
    }

    protected void traverseSelectConstant(Object c) {
        throw new IllegalArgumentException("This translator can be used only for projection free queries.");
    }

    protected void traverseSelectField(String bindName, String fieldName) {
        throw new IllegalArgumentException("This translator can be used only for projection free queries.");
    }

    protected void traverseFromList(FromExpr[] fromExpr) {
        int i = 0;
        while (i < fromExpr.length) {
            this.traverse(fromExpr[i]);
            ++i;
        }
    }

    protected void traverseFromRelation(String relName, String bindName) {
        if (!this.schema.containsKey(relName)) {
            throw new IllegalArgumentException("Relation " + relName + " not found.");
        }
        Relation r = (Relation)this.schema.get(relName);
        if (bindName != null) {
            this.b.push(r, bindName, this.varIndex);
        } else {
            this.b.push(r, relName, this.varIndex);
        }
        Value[] v = new Variable[r.getFieldLength()];
        int i = 0;
        while (i < v.length) {
            v[i] = new Variable(VAR_PREFIX + this.varIndex++);
            ++i;
        }
        this.f.add(Atom.create(relName, v));
    }

    protected void traverseFromSubquery(Query q, String bindName) {
        this.traverse(q);
    }

    protected void traverseWhereConjunction(WhereCondition cond1, WhereCondition cond2) {
        this.traverse(cond1);
        this.traverse(cond2);
    }

    protected void traverseWhereDisjunction(WhereCondition cond1, WhereCondition cond2) {
        this.f.push(Formula.TRUE);
        this.traverse(cond1);
        this.f.push(Formula.TRUE);
        this.traverse(cond2);
        this.f.union();
    }

    protected void traverseWhereNegation(WhereCondition cond) {
        this.f.push(Formula.TRUE);
        this.traverse(cond);
        this.f.negate();
        this.f.fold();
    }

    protected void traverseWhereComparison(WhereCompValue val1, WhereComparator comp, WhereCompValue val2) {
        Value v1 = this.traverse(val1);
        Value v2 = this.traverse(val2);
        if (comp == WhereComparator.EQ) {
            this.f.add(Comparison.create(v1, Comparator.EQ, v2));
        } else if (comp == WhereComparator.NEQ) {
            this.f.add(Comparison.create(v1, Comparator.NEQ, v2));
        } else if (comp == WhereComparator.LE) {
            this.f.add(Comparison.create(v1, Comparator.LE, v2));
        } else if (comp == WhereComparator.GE) {
            this.f.add(Comparison.create(v1, Comparator.GE, v2));
        } else if (comp == WhereComparator.IS) {
            this.f.add(Comparison.create(v1, Comparator.IS, v2));
        } else {
            throw new InternalProblem("Unrecognized operator " + comp);
        }
    }

    protected Value traverseWhereSelectValue(String bindName, String fieldName) {
        if (bindName == null) {
            return new Variable(VAR_PREFIX + this.b.find(fieldName));
        }
        return new Variable(VAR_PREFIX + this.b.find(bindName, fieldName));
    }

    protected Value traverseWhereConstant(Object c) {
        return Constant.create(c);
    }

    protected void traverseDifference(Query expr1, Query expr2) {
        int _varIndex = this.varIndex;
        this.traverse(expr1);
        this.varIndex = _varIndex;
        this.f.push(Formula.TRUE);
        this.traverse(expr2);
        this.f.negate();
        this.f.fold();
    }

    protected void traverseIntersection(Query expr1, Query expr2) {
        int _varIndex = this.varIndex;
        this.traverse(expr1);
        this.varIndex = _varIndex;
        this.traverse(expr2);
    }

    protected void traverseUnion(Query expr1, Query expr2) {
        int _varIndex = this.varIndex;
        this.f.push(Formula.TRUE);
        this.traverse(expr1);
        this.varIndex = _varIndex;
        this.f.push(Formula.TRUE);
        this.traverse(expr2);
        this.f.union();
    }
}

