/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.query.traverse;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Constants;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.FromSubquery;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Intersection;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.Select;
import edu.buffalo.nsf.hippo.data.query.SelectExpr;
import edu.buffalo.nsf.hippo.data.query.SelectField;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.Signature;
import edu.buffalo.nsf.hippo.data.query.Union;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.data.query.traverse.PhonyTransformer;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Map;

public class UniformTransformer
extends PhonyTransformer
implements Constants {
    protected int varIndex;
    protected Map sigs;
    protected Map schema;
    protected String coreSuffix;

    public UniformTransformer(Environment env) {
    }

    public void init(Configuration config) {
        this.schema = config.getSchema();
        this.coreSuffix = config.getCoreSuffix();
    }

    public void shutdown() {
    }

    protected Relation getRelation(String relName) {
        if (relName.endsWith(this.coreSuffix)) {
            relName = relName.substring(0, relName.length() - this.coreSuffix.length());
        }
        return (Relation)this.schema.get(relName);
    }

    public Query transform(Query q) {
        this.varIndex = 0;
        this.sigs = Util.createMap();
        return super.transform(q);
    }

    protected Query transformSelect(SelectList selectList, FromList fromList, WhereCondition whereCondition, GroupByList groupByList) {
        if (groupByList != null) {
            throw new IllegalArgumentException("This translator can be used only for SJUID queires.");
        }
        int _varIndex = this.varIndex;
        FromList f = this.transformFromList(fromList.getFromExpr());
        SelectExpr[] se = new SelectExpr[this.varIndex - _varIndex];
        this.varIndex = _varIndex;
        int k = 0;
        int i = 0;
        while (i < f.getFromExpr().length) {
            FromExpr fe = f.getFromExpr()[i];
            if (fe instanceof FromRelation) {
                FromRelation fr = (FromRelation)fe;
                Relation rel = this.getRelation(fr.getRelationName());
                int j = 0;
                while (j < rel.getFieldLength()) {
                    se[k++] = new SelectField(fr.getRefName(), rel.getField(j).getName(), "X_" + this.varIndex);
                    ++this.varIndex;
                    ++j;
                }
            } else {
                Signature sig = (Signature)this.sigs.get(fe);
                int j = 0;
                while (j < sig.getLength()) {
                    se[k++] = new SelectField(fe.getRefName(), "X_" + this.varIndex, "X_" + this.varIndex);
                    ++this.varIndex;
                    ++j;
                }
            }
            ++i;
        }
        return new Select(new SelectList(se), f, whereCondition, groupByList);
    }

    protected FromExpr transformFromRelation(String relName, String bindName) {
        FromRelation r = new FromRelation(relName, bindName);
        Relation rel = this.getRelation(relName);
        this.varIndex += rel.getFieldLength();
        return r;
    }

    protected FromSubquery transformFromSubquery(Query q, String bindName) {
        int offset = this.varIndex;
        FromSubquery s = new FromSubquery(this.transform(q), bindName);
        Signature sig = new Signature(offset, this.varIndex - offset);
        return s;
    }

    protected Query transformDifference(Query expr1, Query expr2) {
        int _varIndex = this.varIndex;
        Query q1 = this.transform(expr1);
        this.varIndex = _varIndex;
        Query q2 = this.transform(expr2);
        return new Difference(q1, q2);
    }

    protected Query transformIntersection(Query expr1, Query expr2) {
        int _varIndex = this.varIndex;
        Query q1 = this.transform(expr1);
        this.varIndex = _varIndex;
        Query q2 = this.transform(expr2);
        return new Intersection(q1, q2);
    }

    protected Query transformUnion(Query expr1, Query expr2) {
        int _varIndex = this.varIndex;
        Query q1 = this.transform(expr1);
        this.varIndex = _varIndex;
        Query q2 = this.transform(expr2);
        return new Union(q1, q2);
    }
}

