/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.tuple;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleMetaData;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;

public class ConcatTupleStream
extends TupleStream {
    protected TupleMetaData metaData;
    protected TupleStream ts1;
    protected TupleStream ts2;

    public ConcatTupleStream(TupleStream ts1, TupleStream ts2) {
        if (!ts1.getMetaData().equals(ts2.getMetaData())) {
            throw new IllegalArgumentException("Meta data mismatch.");
        }
        this.metaData = ts1.getMetaData();
        this.ts1 = ts1;
        this.ts2 = ts2;
    }

    public TupleMetaData getMetaData() {
        return this.metaData;
    }

    public boolean hasNext() {
        return this.ts1.hasNext() || this.ts2.hasNext();
    }

    public Tuple getNext() {
        if (this.ts1.hasNext()) {
            return this.ts1.getNext();
        }
        return this.ts2.getNext();
    }

    public String toString() {
        return "TSConcat[" + this.ts1 + "," + this.ts2 + "]";
    }
}

