/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.tuple;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public abstract class Tuple {
    protected static Logger logger;
    protected boolean wasNull = false;
    public static Tuple EMPTY_TUPLE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.data.tuple.Tuple");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        EMPTY_TUPLE = new ArrayTuple(new Object[0]);
    }

    public abstract Object getObject(int var1);

    public abstract int getFieldCount();

    public boolean wasNull() {
        return this.wasNull;
    }

    public boolean isNULL() {
        int i = 0;
        while (i < this.getFieldCount()) {
            if (this.getObject(i) != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getString(int fieldIndex) {
        return (String)this.getObject(fieldIndex);
    }

    public boolean getBoolean(int fieldIndex) {
        try {
            return (Boolean)this.getObject(fieldIndex);
        }
        catch (NullPointerException exc) {
            return false;
        }
    }

    public byte getByte(int fieldIndex) {
        try {
            return ((Number)this.getObject(fieldIndex)).byteValue();
        }
        catch (NullPointerException exc) {
            return 0;
        }
    }

    public short getShort(int fieldIndex) {
        try {
            return ((Number)this.getObject(fieldIndex)).shortValue();
        }
        catch (NullPointerException exc) {
            return 0;
        }
    }

    public int getInt(int fieldIndex) {
        try {
            return ((Number)this.getObject(fieldIndex)).intValue();
        }
        catch (NullPointerException exc) {
            return 0;
        }
    }

    public long getLong(int fieldIndex) {
        try {
            return ((Number)this.getObject(fieldIndex)).longValue();
        }
        catch (NullPointerException exc) {
            return 0L;
        }
    }

    public float getFloat(int fieldIndex) {
        try {
            return ((Number)this.getObject(fieldIndex)).floatValue();
        }
        catch (NullPointerException exc) {
            return 0.0f;
        }
    }

    public double getDouble(int fieldIndex) {
        try {
            return ((Number)this.getObject(fieldIndex)).doubleValue();
        }
        catch (NullPointerException exc) {
            return 0.0;
        }
    }

    public Date getDate(int fieldIndex) {
        return (Date)this.getObject(fieldIndex);
    }

    public Time getTime(int fieldIndex) {
        return (Time)this.getObject(fieldIndex);
    }

    public Timestamp getTimestamp(int fieldIndex) {
        return (Timestamp)this.getObject(fieldIndex);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("T[");
        int i = 0;
        while (i < this.getFieldCount()) {
            result.append(this.getObject(i)).append(',');
            ++i;
        }
        result.setCharAt(result.length() - 1, ']');
        return result.toString();
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.getFieldCount()) {
            h *= 32;
            if (this.getObject(i) != null) {
                h += this.getObject(i).hashCode();
            }
            ++i;
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o instanceof Tuple) {
            return Tuple.equal(this, (Tuple)o);
        }
        return false;
    }

    protected static boolean equal(Tuple t1, Tuple t2) {
        if (t1 == t2) {
            return true;
        }
        boolean result = t1.getFieldCount() == t2.getFieldCount();
        int count = t1.getFieldCount();
        int i = 0;
        while (result && i < count) {
            Object o2;
            Object o1 = t1.getObject(i);
            result = o1 == (o2 = t2.getObject(i)) || o1 != null && o2 != null && o1.equals(o2);
            ++i;
        }
        return result;
    }

    public static Tuple create(Object o) {
        Object[] arr = new Object[]{o};
        return Tuple.create(arr);
    }

    public static Tuple create(Object[] row) {
        return new ArrayTuple(row);
    }

    public static Tuple extract(Tuple tuple, int start, int count) {
        return new Subtuple(tuple, start, count);
    }

    public static Tuple concat(Tuple tuple1, Tuple tuple2) {
        return new ConcatTuple(tuple1, tuple2);
    }

    protected static class ArrayTuple
    extends Tuple {
        protected Object[] row;

        public ArrayTuple(Object[] row) {
            this.row = row;
        }

        public int getFieldCount() {
            return this.row.length;
        }

        public Object getObject(int fieldIndex) {
            if (fieldIndex < 0 || fieldIndex > this.row.length - 1) {
                throw new IllegalArgumentException("Wrong field index.");
            }
            this.wasNull = this.row[fieldIndex] == null;
            return this.row[fieldIndex];
        }
    }

    protected static class Subtuple
    extends Tuple {
        protected Tuple tuple;
        protected int startField;
        protected int fieldCount;

        protected Subtuple(Tuple tuple, int startField, int fieldCount) {
            this.startField = startField;
            this.fieldCount = fieldCount;
            this.tuple = tuple;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        public Object getObject(int fieldIndex) {
            if (fieldIndex < 0 || fieldIndex > this.fieldCount - 1) {
                throw new IllegalArgumentException("Wrong field index.");
            }
            Object result = this.tuple.getObject(this.startField + fieldIndex);
            this.wasNull = this.tuple.wasNull();
            return result;
        }
    }

    protected static class ConcatTuple
    extends Tuple {
        protected Tuple tuple1;
        protected Tuple tuple2;
        protected int fieldCount1;
        protected int fieldCount2;

        public ConcatTuple(Tuple tuple1, Tuple tuple2) {
            this.tuple1 = tuple1;
            this.tuple2 = tuple2;
            this.fieldCount1 = tuple1.getFieldCount();
            this.fieldCount2 = tuple2.getFieldCount();
        }

        public int getFieldCount() {
            return this.fieldCount1 + this.fieldCount2;
        }

        public Object getObject(int fieldIndex) {
            Object o;
            if (fieldIndex < this.fieldCount1) {
                o = this.tuple1.getObject(fieldIndex);
                this.wasNull = this.tuple1.wasNull();
            } else {
                o = this.tuple2.getObject(fieldIndex - this.fieldCount1);
                this.wasNull = this.tuple2.wasNull();
            }
            return o;
        }
    }
}

