/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.tuple;

import edu.buffalo.nsf.hippo.data.tuple.ConcatTupleStream;
import edu.buffalo.nsf.hippo.data.tuple.FilterTupleStream;
import edu.buffalo.nsf.hippo.data.tuple.ListTupleStream;
import edu.buffalo.nsf.hippo.data.tuple.SQLTupleStream;
import edu.buffalo.nsf.hippo.data.tuple.TrimmingTupleStream;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleFilter;
import edu.buffalo.nsf.hippo.data.tuple.TupleMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;

public abstract class TupleStream {
    public static TupleStream EMPTY_TUPLE_STREAM = new ListTupleStream(Collections.EMPTY_LIST, TupleMetaData.EMPTY_META_DATA);

    public abstract TupleMetaData getMetaData();

    public abstract boolean hasNext();

    public abstract Tuple getNext();

    public static TupleStream create(ResultSet rs) throws SQLException {
        return new ListTupleStream(rs);
    }

    public static TupleStream create(ResultSet rs, Statement stmt) throws SQLException {
        return new SQLTupleStream(rs, stmt);
    }

    public static TupleStream concatenate(TupleStream ts1, TupleStream ts2) {
        return new ConcatTupleStream(ts1, ts2);
    }

    public static TupleStream filter(TupleFilter f, TupleStream ts) {
        return new FilterTupleStream(f, ts);
    }

    public static TupleStream trim(TupleStream ts, int length) {
        return new TrimmingTupleStream(ts, length);
    }
}

