/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.prolog;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.parser.ParseException;
import edu.buffalo.nsf.hippo.parser.QueryParser;
import edu.buffalo.nsf.hippo.prolog.ProverFactory;
import java.io.StringReader;
import java.util.Map;

public abstract class AbstractProverEngine
implements Engine {
    protected Environment env;
    protected DataSource source;
    protected ProverFactory factory;
    protected Map ri;
    protected QueryParser parser;

    protected AbstractProverEngine(Environment env) {
        this.env = env;
    }

    public void init(Configuration config) {
        this.source = this.env.getDataSource(config);
        this.factory = this.env.getProverFactory(config);
        this.ri = config.getResultInterpretation();
    }

    protected Query parseQuery(String query) throws ParseException {
        if (this.parser == null) {
            this.parser = new QueryParser(new StringReader(query));
        } else {
            this.parser.ReInit(new StringReader(query));
        }
        return this.parser.parseQuery();
    }

    public void shutdown() {
        this.env.dispose(this.factory);
        this.env.dispose(this.source);
    }

    public abstract TupleStream getConsistentAnswer(String var1) throws ParseException;
}

