/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.prolog;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.OuterJoin;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTransformer;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.parser.ParseException;
import edu.buffalo.nsf.hippo.prolog.AbstractProverEngine;
import edu.buffalo.nsf.hippo.prolog.Prover;
import edu.buffalo.nsf.hippo.prolog.ProverTupleFilter;
import org.apache.log4j.Logger;

public class CoreProverEngine
extends AbstractProverEngine {
    protected Logger logger;
    protected QueryTransformer f;
    protected QueryTransformer g;
    static /* synthetic */ Class class$0;

    public CoreProverEngine(Environment env) {
        super(env);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.prolog.CoreProverEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = Logger.getLogger((Class)clazz);
    }

    public void init(Configuration config) {
        super.init(config);
        this.f = this.env.getEnvelopeOperator(config);
        this.g = this.env.getCoreOperator(config);
    }

    public void shutdown() {
        this.env.dispose(this.f);
        this.env.dispose(this.g);
        super.shutdown();
    }

    public TupleStream getConsistentAnswer(String sqlQuery) throws ParseException {
        Query q = this.parseQuery(sqlQuery);
        Query gq = this.g.transform(q);
        TupleStream core = this.source.executeQuery(gq);
        Query fq = this.f.transform(q);
        if (fq instanceof OuterJoin) {
            OuterJoin Fq = (OuterJoin)fq;
            OuterJoin rq = new OuterJoin(new Difference(Fq.query, gq), Fq.length, Fq.rel, Fq.offset);
            OuterJoin sq = new OuterJoin(q, Fq.length, Fq.rel, Fq.offset);
            Prover p = this.factory.create(sq);
            ProverTupleFilter pf = new ProverTupleFilter(p, this.ri);
            TupleStream rest = TupleStream.filter(pf, this.source.executeQuery(rq));
            TupleStream trest = TupleStream.trim(rest, Fq.length);
            TupleStream result = TupleStream.concatenate(core, trest);
            return result;
        }
        Difference rq = new Difference(fq, gq);
        Prover p = this.factory.create(q);
        ProverTupleFilter pf = new ProverTupleFilter(p, this.ri);
        TupleStream rest = TupleStream.filter(pf, this.source.executeQuery(rq));
        TupleStream result = TupleStream.concatenate(core, rest);
        return result;
    }
}

