/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.prolog;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.formula.Formula;
import edu.buffalo.nsf.hippo.data.graph.ExternalHypergraphExtention;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTranslator;
import edu.buffalo.nsf.hippo.prolog.HProver;
import edu.buffalo.nsf.hippo.prolog.Prover;
import edu.buffalo.nsf.hippo.prolog.ProverEnv;
import edu.buffalo.nsf.hippo.prolog.ProverFactory;
import java.util.Map;
import org.apache.log4j.Logger;

public final class HProverFactory
extends ProverFactory {
    protected static Logger logger;
    protected Environment env;
    protected Map schema;
    protected DataSource source;
    protected Hypergraph internal;
    protected Hypergraph h;
    protected QueryTranslator trans;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.prolog.HProverFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public HProverFactory(Environment env) {
        this.env = env;
    }

    public void init(Configuration config) {
        this.schema = config.getSchema();
        this.source = this.env.getDataSource(config);
        this.internal = this.source.getHypergraph();
        this.h = new ExternalHypergraphExtention(this.internal, this.source);
        this.trans = this.env.getTranslator(config);
    }

    public void shutdown() {
        this.env.dispose(this.trans);
        this.env.dispose(this.source);
    }

    public Prover create(Query q) {
        Formula f = this.trans.translate(q);
        return new HProver(f, new ProverEnv(this.h));
    }
}

