/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.util;

import edu.buffalo.nsf.hippo.util.FormatUtil;
import edu.buffalo.nsf.hippo.util.StatsManager;
import java.util.Iterator;
import java.util.Map;

public abstract class Stats {
    public static final String ENVELOPE_TUPLES = "Tuples in envelope";
    public static final String GOOD_TUPLES = "Consistent tuples from envelope";
    public static final String BAD_TUPLES = "Tuples inconsistent in envelope";
    public static final String QUERIES_EXEC = "Queries executed";
    public static final String TUPLES_FROM_DB = "Records transmited from database";
    public static final String FST_PHASE_CHECK = "Consistency decided in heuristics";
    public static final String SND_PHASE_CHECK = "Unknown consistency in heuristics";
    public static final String HYPERGRAPH_STATS = "Hypergraph statistics";
    public static final String ROOT_STATS = "Main statistics";

    public static Stats getRootStats() {
        return StatsManager.getRootStats();
    }

    public static Stats getStats(String name) {
        return StatsManager.getStats(name);
    }

    public abstract double read(Object var1);

    public abstract double reset(Object var1);

    public abstract double remove(Object var1);

    public abstract double touch(Object var1, double var2);

    public abstract String getName();

    public abstract Map getReadings();

    public Iterator getCategories() {
        return this.getReadings().keySet().iterator();
    }

    public double touch(Object category) {
        return this.touch(category, 1.0);
    }

    public String toString() {
        return "Stats(" + this.getName() + ") = " + this.getReadings();
    }

    public String toXMLString() {
        String result = "<stats ";
        if (this.getName() != null) {
            result = String.valueOf(result) + "name=\"" + FormatUtil.escapeXML(this.getName()) + "\"";
        }
        result = String.valueOf(result) + ">\n";
        Iterator categories = this.getCategories();
        while (categories.hasNext()) {
            Object category = categories.next();
            result = String.valueOf(result) + "<category name=\"" + FormatUtil.escapeXML(category.toString()) + "\" " + "reading=\"" + FormatUtil.escapeXML("" + (int)this.read(category)) + "\" " + "/>\n";
        }
        result = String.valueOf(result) + "</stats>";
        return result;
    }
}

