/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.util;

import edu.buffalo.nsf.hippo.util.SimpleStats;
import edu.buffalo.nsf.hippo.util.Stats;
import edu.buffalo.nsf.hippo.util.StatsWrapper;
import edu.buffalo.nsf.hippo.util.TrimmableStack;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.log4j.Logger;

public class StatsManager {
    protected static Logger logger;
    protected static Hashtable stats;
    protected static Stats root;
    protected static Stack statsStack;
    protected static Stats empty;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.util.StatsManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        stats = new Hashtable();
        root = new SimpleStats("Main statistics");
        statsStack = new TrimmableStack(10, 20);
        empty = StatsManager.createStats(null);
    }

    public static void pushNewStats(String name) {
        if (StatsManager.exists(name)) {
            StatsManager.removeStats(name);
        }
        statsStack.push(StatsManager.getStats(name));
    }

    public static void pushStats(String name) {
        statsStack.push(StatsManager.getStats(name));
    }

    public static void popStats() {
        if (!statsStack.empty()) {
            statsStack.pop();
        }
    }

    public static Stats peekStats() {
        if (!statsStack.empty()) {
            return (Stats)statsStack.peek();
        }
        return empty;
    }

    public static boolean exists(String name) {
        return stats.containsKey(name);
    }

    protected static Stats createStats(String name) {
        return new StatsWrapper(root, new SimpleStats(name));
    }

    public static Stats getRootStats() {
        return root;
    }

    public static Stats getStats(String name) {
        if (!StatsManager.exists(name)) {
            stats.put(name, StatsManager.createStats(name));
        }
        return (Stats)stats.get(name);
    }

    public static void removeStats(String name) {
        stats.remove(name);
    }
}

