/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.util;

import edu.buffalo.nsf.hippo.util.MultiMapImpl;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.MultiMap;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;

public final class Util {
    private static Logger logger;
    private static boolean isLoggerInitialized;
    public static Map EMPTY_MAP;
    static /* synthetic */ Class class$0;

    static {
        isLoggerInitialized = false;
        EMPTY_MAP = Collections.unmodifiableMap(Util.createMap(0));
    }

    public static void setUpLogger() {
        Util.setUpLogger(Level.DEBUG);
    }

    public static void setUpLogger(Level l) {
        if (isLoggerInitialized) {
            return;
        }
        try {
            Logger.getRootLogger().setLevel(l);
            PatternLayout layout = new PatternLayout("%p [(%d)%c{1}(%L) %M] - %m \n");
            Logger.getRootLogger().addAppender((Appender)new FileAppender((Layout)layout, "hippo.log", true));
            PatternLayout consLayout = new PatternLayout("%m \n");
            LevelRangeFilter f = new LevelRangeFilter();
            f.setLevelMin(Level.WARN);
            f.setAcceptOnMatch(true);
            ConsoleAppender consApp = new ConsoleAppender((Layout)consLayout, "System.err");
            consApp.addFilter((Filter)f);
            Logger.getRootLogger().addAppender((Appender)consApp);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.util.Util");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger = Logger.getLogger((Class)clazz);
            logger.info((Object)"Logger initialized.");
            isLoggerInitialized = true;
        }
        catch (IOException exc) {
            try {
                System.err.println(exc.getMessage());
                logger.error((Object)"Problem with log file.", (Throwable)exc);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int getTupleCount(ResultSet rs) {
        return -1;
    }

    public static List toList(Collection c) {
        if (c instanceof List) {
            return (List)c;
        }
        return Util.createList(c);
    }

    public static Set toSet(Collection c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return Util.createSet(c);
    }

    public static List createList() {
        return new ArrayList();
    }

    public static List createList(Collection c) {
        return new ArrayList(c);
    }

    public static List createList(int initialSize) {
        return new ArrayList(initialSize);
    }

    public static List union(List c1, List c2) {
        List result = Util.createList(c1.size() + c2.size());
        result.addAll(c1);
        result.addAll(c2);
        return result;
    }

    public static Set union(Set s1, Set s2) {
        Set result = Util.createSet(s1.size() + s2.size());
        result.addAll(s1);
        result.addAll(s2);
        return result;
    }

    public static Set cut(Set s1, Set s2) {
        Set result = Util.createSet();
        result.addAll(s1);
        result.retainAll(s2);
        return result;
    }

    public static Map createLRUMap(int capacityLimit) {
        return new LRUMap(capacityLimit);
    }

    public static MultiMap createMultiMap(int initialSize) {
        return new MultiMapImpl(initialSize);
    }

    public static Map createMap() {
        return new HashMap();
    }

    public static Map createMap(Map map) {
        return new HashMap(map);
    }

    public static Map createMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static Set createSet() {
        return new HashSet();
    }

    public static Set createSet(Collection c) {
        return new HashSet(c);
    }

    public static Set createSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }
}

