/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.fastpath;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.Driver;
import org.postgresql.PGConnection;
import org.postgresql.PG_Stream;
import org.postgresql.fastpath.FastpathArg;
import org.postgresql.jdbc1.AbstractJdbc1Connection;
import org.postgresql.util.PSQLException;

public class Fastpath {
    protected Hashtable func = new Hashtable();
    protected PGConnection conn;
    protected PG_Stream stream;

    public Fastpath(PGConnection conn, PG_Stream stream) {
        this.conn = conn;
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fastpath(int fnid, boolean resulttype, FastpathArg[] args) throws SQLException {
        PG_Stream pG_Stream = this.stream;
        synchronized (pG_Stream) {
            try {
                this.stream.SendInteger(70, 1);
                this.stream.SendInteger(0, 1);
                this.stream.SendInteger(fnid, 4);
                this.stream.SendInteger(args.length, 4);
                int i = 0;
                while (i < args.length) {
                    args[i].send(this.stream);
                    ++i;
                }
                this.stream.flush();
            }
            catch (IOException ioe) {
                throw new PSQLException("postgresql.fp.send", new Integer(fnid), (Object)ioe);
            }
            Object result = null;
            StringBuffer errorMessage = null;
            boolean l_endQuery = false;
            block13: while (!l_endQuery) {
                int c = this.stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.stream.ReceiveInteger(4);
                        String msg = this.stream.ReceiveString(this.conn.getEncoding());
                        break;
                    }
                    case 69: {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        errorMessage.append(this.stream.ReceiveString(this.conn.getEncoding()));
                        break;
                    }
                    case 78: {
                        ((AbstractJdbc1Connection)this.conn).addWarning(this.stream.ReceiveString(this.conn.getEncoding()));
                        break;
                    }
                    case 86: {
                        int l_nextChar = this.stream.ReceiveChar();
                        if (l_nextChar != 71) continue block13;
                        int sz = this.stream.ReceiveIntegerR(4);
                        if (resulttype) {
                            result = new Integer(this.stream.ReceiveIntegerR(sz));
                        } else {
                            byte[] buf = new byte[sz];
                            this.stream.Receive(buf, 0, sz);
                            result = buf;
                        }
                        int l_endChar = this.stream.ReceiveChar();
                        break;
                    }
                    case 90: {
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.fp.protocol", new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                throw new PSQLException("postgresql.fp.error", (Object)errorMessage.toString());
            }
            Integer n = result;
            return n;
        }
    }

    public Object fastpath(String name, boolean resulttype, FastpathArg[] args) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("Fastpath: calling " + name);
        }
        return this.fastpath(this.getID(name), resulttype, args);
    }

    public int getInteger(String name, FastpathArg[] args) throws SQLException {
        Integer i = (Integer)this.fastpath(name, true, args);
        if (i == null) {
            throw new PSQLException("postgresql.fp.expint", (Object)name);
        }
        return i;
    }

    public byte[] getData(String name, FastpathArg[] args) throws SQLException {
        return (byte[])this.fastpath(name, false, args);
    }

    public void addFunction(String name, int fnid) {
        this.func.put(name, new Integer(fnid));
    }

    public void addFunctions(ResultSet rs) throws SQLException {
        while (rs.next()) {
            this.func.put(rs.getString(1), new Integer(rs.getInt(2)));
        }
    }

    public int getID(String name) throws SQLException {
        Integer id = (Integer)this.func.get(name);
        if (id == null) {
            throw new PSQLException("postgresql.fp.unknown", (Object)name);
        }
        return id;
    }
}

