/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2.optional;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class PooledConnectionImpl
implements PooledConnection {
    private List listeners = new LinkedList();
    private Connection con;
    private ConnectionHandler last;
    private boolean autoCommit;
    static /* synthetic */ Class class$java$sql$Connection;

    protected PooledConnectionImpl(Connection con, boolean autoCommit) {
        this.con = con;
        this.autoCommit = autoCommit;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.last != null) {
            this.last.close();
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        try {
            this.con.close();
            Object var3_2 = null;
            this.con = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.con = null;
            throw throwable;
        }
    }

    public Connection getConnection() throws SQLException {
        ConnectionHandler handler;
        if (this.con == null) {
            throw new SQLException("This PooledConnection has already been closed!");
        }
        if (this.last != null) {
            this.last.close();
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            this.con.clearWarnings();
        }
        this.con.setAutoCommit(this.autoCommit);
        this.last = handler = new ConnectionHandler(this.con);
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = PooledConnectionImpl.class$("java.sql.Connection")) : class$java$sql$Connection}, (InvocationHandler)handler);
    }

    void fireConnectionClosed() {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        int i = 0;
        while (i < local.length) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = new ConnectionEvent(this);
            }
            listener.connectionClosed(evt);
            ++i;
        }
    }

    void fireConnectionFatalError(SQLException e) {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        int i = 0;
        while (i < local.length) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = new ConnectionEvent(this, e);
            }
            listener.connectionErrorOccurred(evt);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection con;
        private boolean automatic = false;

        public ConnectionHandler(Connection con) {
            this.con = con;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled connection wrapping physical connection " + this.con;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.con.hashCode());
                }
                if (method.getName().equals("equals")) {
                    if (args[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        return Proxy.isProxyClass(args[0].getClass()) && ((ConnectionHandler)Proxy.getInvocationHandler((Object)args[0])).con == this.con ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException e) {
                        return Boolean.FALSE;
                    }
                }
                return method.invoke((Object)this.con, args);
            }
            if (method.getName().equals("isClosed")) {
                return this.con == null ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.con == null) {
                throw new SQLException(this.automatic ? "Connection has been closed automatically because a new connection was opened for the same PooledConnection or the PooledConnection has been closed" : "Connection has been closed");
            }
            if (method.getName().equals("close")) {
                SQLException ex = null;
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        ex = e;
                    }
                }
                this.con.clearWarnings();
                this.con = null;
                PooledConnectionImpl.this.last = null;
                PooledConnectionImpl.this.fireConnectionClosed();
                if (ex != null) {
                    throw ex;
                }
                return null;
            }
            return method.invoke((Object)this.con, args);
        }

        public void close() {
            if (this.con != null) {
                this.automatic = true;
            }
            this.con = null;
        }
    }
}

