package edu.buffalo.nsf.hippo;


/**
 *  Interface marking objects which work may depend on the state of configuration.
 */
public interface Configurable
{
    /**
     * This method initializes the given object with configuration data. 
     * This method should be used before any future usage of this object.
     */
    public void init(Configuration config);

    /** 
     *  Method releasing resources of this engine. The engine shouldn't be
     *  used any more after calling this method.
     */
    public void shutdown();
}
