package edu.buffalo.nsf.hippo;

import java.sql.Connection;

import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTransformer;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTranslator;
import edu.buffalo.nsf.hippo.prolog.ProverFactory;

/**
 *  Environment object.
 */
public interface Environment
{
    public Connection getConnection(Configuration config);

    public void release(Connection db);

    public void dispose(Configurable c);

    public DataSource getDataSource (Configuration config);

    /**
     *  Return a proper prover factory object.
     */
    public ProverFactory getProverFactory(String name, Configuration config);

    public ProverFactory getProverFactory(Configuration config);

    public Engine getEngine(Configuration config);

    public QueryTranslator getTranslator(Configuration config);
    
    public QueryTransformer getCoreOperator(Configuration config);

    public QueryTransformer getShellOperator(Configuration config);

    public QueryTransformer getEnvelopeOperator(Configuration config);

    public void shutdown();
}

