package edu.buffalo.nsf.hippo.data.formula;

import java.util.Map;

public class Atom extends Formula
{   
    protected String       relName;
    protected ValueVector  vec;

    protected Atom(String relName, ValueVector vec)
    {
        this.relName = relName;
        this.vec     = vec;
    }

    public static Formula create(String relName, ValueVector vec)
    {
        return new Atom(relName,vec);
    }

    public static Formula create(String relName, Value[] vec)
    {
        return new Atom(relName,new ValueVector(vec));
    }

    public Formula substitute(Map s)
    {
        ValueVector t = vec.substitute(s);

        return create(relName,t);
    }

    public boolean isGround()
    {
        return vec.isGround();
    }

    public String toString()
    {
        return relName + vec;
    }

    public String getRelationName()
    {
        return relName;
    }

    public ValueVector getValueVector()
    {
        return vec;
    }
}
