package edu.buffalo.nsf.hippo.data.formula;

import java.util.Map;

public class Comparison extends Formula
{
    protected Value      val1;
    protected Comparator comp;
    protected Value      val2;

    protected Comparison(Value val1, Comparator comp, Value val2)
    {
        this.val1 = val1;
        this.comp = comp;
        this.val2 = val2;
    }

    public static Formula create(Value val1, Comparator comp, Value val2)
    {
        return new Comparison(val1,comp,val2);
    }

    public Formula substitute(Map s)
    {
        Value v1 =  val1.substitute(s);
        Value v2 =  val2.substitute(s);

        if (v1.isGround() && v2.isGround()) {
            Comparable c1 = (Comparable) ((Constant) v1).getValue();
            Comparable c2 = (Comparable) ((Constant) v2).getValue();

            if (comp.compare(c1,c2)) {
                return TRUE;
            } else {
                return FALSE;
            }
        } else {
            return create(v1,comp,v2);
        }
    }

    public String toString()
    {
        return "" + val1 + " " + comp + " " + val2;
    }
}
