package edu.buffalo.nsf.hippo.data.formula;

import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.util.Util;

public class Conjunction extends Formula
{
    protected static Logger logger = Logger.getLogger(Conjunction.class);

    protected List l;

    protected Conjunction(List l)
    {
        this.l = l;
    }

    public static Formula create(Formula expr)
    {
        List l = Util.createList(1);

        l.add(expr);

        return create(l);
    }

    public static Formula create(Formula expr1, Formula expr2)
    {
        List l = Util.createList(2);
      
        l.add(expr1);
        l.add(expr2);

        return create(l);
    }

    public static Formula create(List l)
    {
        List l2 = Util.createList(l.size());

        for (int i = 0; i < l.size(); i++) {
            Formula f = (Formula) l.get(i);

            if (f == null) {
                throw new IllegalArgumentException("Null argument.");
            }

            if (f == FALSE) {
                return FALSE;
            }

            if (f == TRUE) {
                continue;
            }

            l2.add(f);
        }

        if (l2.isEmpty()) {
            return TRUE;
        }

        return new Conjunction(l2);
    }

    protected Formula pushDownNegations(boolean negationCarry)
    {
        List tmp = Util.createList();
        
        //logger.debug("Pushing negations in : "+ l);

        for (int i = 0; i < l.size(); i++) {
            Formula f = (Formula) l.get(i);

            tmp.add(f.pushDownNegations(negationCarry));
        }

        if (negationCarry) {
            return Disjunction.create(tmp);
        } else {
            return Conjunction.create(tmp);
        }
    }


    protected Formula pushDownDisjunctions()
    {
        List tmp = Util.createList();

        for (int i = 0; i < l.size(); i++) {
            tmp.add(((Formula) l.get(i)).pushDownDisjunctions());
        }

        return Conjunction.create(tmp);
    }

    public void normalize()
    {
        int i = 0;
        while (i < l.size()) {
            Formula f = (Formula) l.get(i);

            f.normalize();

            if (f instanceof Conjunction) {
                Conjunction c = (Conjunction) l.remove(i);
                l.addAll(c.l);
            } else {	    
                i++;
            }
        }
    }

    public Formula substitute(Map substitution)
    {
        List tmp = Util.createList();
      
        for (int i = 0; i < l.size(); i++) {            
            Formula f = (Formula) l.get(i);
            Formula g = f.substitute(substitution);

            tmp.add(g);
        }

        return Conjunction.create(tmp);
    }


    public String toString()
    {
        if (this == TRUE) {
            return "true";
        }

        if (this == FALSE) {
            return "false";
        }

        if (l.isEmpty()) {
            return "TRUE";
        }

        String result = new String();

        for (int i = 0; i < l.size(); i++) {

            result += "(" + l.get(i).toString() + ")";

            if (i < l.size() - 1) {
                result += " AND ";
            }
        }

        return result;
    }

    public List getConjuncts()
    {
        return l;
    }
}
