package edu.buffalo.nsf.hippo.data.formula;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

public abstract class Formula
{
    private static Logger logger = Logger.getLogger(Formula.class);

    public static final Formula TRUE  = 
        new Conjunction(Collections.EMPTY_LIST);

    public static final Formula FALSE = 
        Conjunction.create(new Disjunction(Collections.EMPTY_LIST));

    public abstract String toString();

    public abstract Formula substitute(Map substitution);

    protected Formula pushDownNegations(boolean negationCarry)
    {
        if (negationCarry) {
            return Negation.create(this);
        } else {
            return this;
        }
    }

    /*assuming that negations are already pushed down */
    protected Formula pushDownDisjunctions()
    {
        return this;
    }

    public Formula negate()
    {
        return pushDownNegations(true);
    }
    
    public void normalize()
    {
    }

    public Formula toCNF()
    {
        //logger.debug("Taking to CNF");

        Formula result = this;
      
        //logger.debug("Input formula:" + result);

        result = result.pushDownNegations(false);

        //logger.debug("AFTER:Negation push down:" +result);
        //result.normalize();

        result = result.pushDownDisjunctions();

        //logger.debug("AFTER:Disjunction push down:" +result);
        result.normalize();

        if (! (result instanceof Conjunction)) {
	 
            if (! (result instanceof Disjunction)) {
                result = Disjunction.create(result);
            }
	 
            result = Conjunction.create(result);
        } else {
            List l = ((Conjunction) result).l;

            for (int i = 0; i < l.size(); i++) {
                if (! (l.get(i) instanceof Disjunction)) {
                    l.set(i,Disjunction.create((Formula) l.get(i)));
                }
            }
        }

        return result;
    }
}
