package edu.buffalo.nsf.hippo.data.formula;

import java.util.Map;

public class Negation extends Formula
{
    protected Formula f;
   
    protected Negation(Formula f)
    {
        this.f = f;
    }

    public static Formula create(Formula f)
    {
        if (f == null) {
            throw new IllegalArgumentException("Null argument.");
        }

        if (f == TRUE || f == FALSE) {
            return f.negate();
        } 

        return new Negation(f);
    }
   
    protected Formula pushDownNegations(boolean negationCarry)
    {
        return f.pushDownNegations(!negationCarry);
    }


    public Formula substitute(Map substitution)
    {
        Formula g = f.substitute (substitution);

        return create(g);
    }

    public void normalize() 
    {
        f.normalize();
    }
   
    public String toString()
    {
        return "NOT (" + f.toString() + ")";
    }
    
    public Formula getNegatedFormula()
    {
        return f;
    }
}
