 package edu.buffalo.nsf.hippo.data.formula;

import java.util.Arrays;
import java.util.Map;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;

public class ValueVector
{
    protected Value[] val;

    public ValueVector(Value[] val)
    {
        this.val = val;
    }

    public boolean isGround()
    {
        for (int i = 0; i < val.length; i++) {
            if (! val[i].isGround()) {
                return false;
            }
        }

        return true;
    }

    public ValueVector substitute(Map s)
    {
        Value[] t = new Value[val.length];

        for (int i = 0; i < val.length; i++) {
            t[i] = val[i].substitute(s);
        }

        return new ValueVector(t);
    }

    public Tuple toTuple()
    {
        if (! isGround()) {
            throw new IllegalStateException("ValueVector not ground.");
        }

        Object[] v = new Object[val.length];

        for (int i = 0; i < v.length; i++) {
            v[i] = ((Constant) val[i]).getValue();
        }

        return Tuple.create(v);
    }

    public String toString()
    {
        return Arrays.asList(val).toString();
    }
}
