package edu.buffalo.nsf.hippo.data.graph;

import java.util.Iterator;
import java.util.Set;

/**
 * Conflic hypergraph.
 */
public abstract class Hypergraph
{
    /**
     * Returns a set of edges being incident to vertex v.
     */
    public abstract Set incident(Vertex v);

    /**
     *  Checks whether the input set of vertices is 
     *  independent in the scope of this hypergraph.
     */
    public abstract boolean  isIndependent(Set vertices);

    /**
     *  Checks whether the given vertex is in any conflict.
     */
    public abstract boolean  isConflicting(Vertex v);

    /**
     *  Checks whether the given vertex exist in 
     *  the hypergraph. 
     *  It is not equivalent to being in any conflict.
     */
    public abstract boolean contains(Vertex v);

    /**
     *  Extension of {@link #contains(Vertex)} to a set of vertices.
     */
    public boolean contains(Set vertices)
    {
        Iterator iter   = vertices.iterator();
        boolean  result = true;
        
        
        while (result && iter.hasNext()) {
            Vertex v = (Vertex) iter.next();
            
            result = contains(v);
        }

        return result;
    }
}
