package edu.buffalo.nsf.hippo.data.graph;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.util.HashUtil;

public class Vertex
{
    protected String   relationName;
    protected Tuple    tuple;

    protected int      hashCode;

    private Logger logger = Logger.getLogger(Vertex.class);

    protected Vertex(String relationName, Tuple tuple)
    {
        //TODO:check if metadata conforms realtions data
        this.relationName = relationName;
        this.tuple        = tuple;

        this.hashCode     = HashUtil.hashCode(this);

        //logger.debug("Created " + this + " with hash code " + hashCode);
    }

    public static Vertex create(String relationName, Tuple tuple)
    {
        return new Vertex(relationName,tuple);
    }

    public String getRelationName()
    {
        return relationName;
    }

    public Tuple getTuple()
    {
        return tuple;
    }

    public boolean equals(Object o) 
    {
        if (o instanceof Vertex) {
            return equal(this,(Vertex) o);
        } else {
            return false;
        }
    }

    public boolean equal(Vertex v1, Vertex v2)
    {
        //        logger.debug("Comparing " + v1 + " with " + v2);

        return v1 == v2 || 
            ( v1 != null && v2 != null &&
              v1.getRelationName().equals(v2.getRelationName()) && 
              v1.getTuple().equals(v2.getTuple()) );
    }

    public int hashCode()
    {
        return hashCode;
    }

    public String toString()
    {
        return "V:(" + relationName + "," + tuple + ")";
    }
}
