package edu.buffalo.nsf.hippo.data.query;

import java.util.List;
import java.util.Map;

import edu.buffalo.nsf.hippo.util.Util;

public class FromList
{
    protected FromExpr[] fromExpr;
    protected int        exprType;

    public FromList(List fromExprs)
    {
        this((FromExpr[]) fromExprs.toArray(new FromExpr[0]));
    }

    public FromList(FromExpr[] fromExpr)
    {
        this.fromExpr = fromExpr;

        exprType = Query.NONE;
        for (int i = 0; i < fromExpr.length; i++) {
            this.exprType |= fromExpr[i].getExprType();
        }
    }

    public FromExpr[] getFromExpr()
    {
        return fromExpr;
    }

    public int getExprType()
    {
        return exprType;
    }

    public String toSQLString(Map params)
    {
        String result = "";

        for (int i = 0; i < fromExpr.length; i++) {
            result += fromExpr[i].toSQLString(params);
            if (i < fromExpr.length - 1) {
                result += ", ";
            }
        }

        return result;
    }

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }
}
