package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

import edu.buffalo.nsf.hippo.util.Util;

public class FromRelation extends FromExpr
{
    protected String relName;
    protected String bindName;

    public FromRelation(String relName)
    {
        this(relName,null);
    }

    public FromRelation(String relName, String bindName)
    {
        this.relName  = relName;
        this.bindName = bindName;
    }

    public String getBindingName()
    {
        return bindName;
    }

    public String getRelationName()
    {
        return relName;
    }

    public String getRefName()
    {
        if (bindName != null) {
            return bindName;
        } else {
            return relName;
        }
    }

    public int getExprType()
    {
        return Query.RELATION;
    }

    public String toSQLString(Map params)
    {
        return relName + ((bindName != null) ? (" " + bindName) : (""));
    }

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }
}
