package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

import edu.buffalo.nsf.hippo.util.Util;

public class GroupByExpr
{
    protected String bindName;
    protected String fieldName;

    public GroupByExpr(String bindName, String fieldName)
    {
        this.bindName  = bindName;
        this.fieldName = fieldName;
    }

    public String getBindingName()
    {
        return bindName;
    }

    public String getFieldName()
    {
        return fieldName;
    }

    public String toSQLString(Map params)
    {
        return ((bindName != null) ? (bindName + ".") : ("")) + fieldName;
    }

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }
}
