package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.util.Util;

public class OuterJoin extends Query
{
    public Query      query;
    public int        length;
    public Relation[] rel;
    public int[]      offset;

    public OuterJoin (Query query, int length, Relation[] rel, int[] offset) 
    {
        this.query = query;
        this.length = length;
        this.rel = rel;        
        this.offset = offset;
    }
    
    

    public int getExprType()
    {
        return query.getExprType() | Query.OUTER_JOIN;
    }

    public String toSQLString(Map params)
    {
        String buf = new String();

        buf+="SELECT * FROM (" ;
//         buf+="SELECT ";
//         for (int i = 0; i < length; i++) {
//             buf+= "X_" + i;
//             if (i < length - 1) {
//                 buf+=',';
//             }
//         }
//         buf+=" FROM (";
        buf+=query.toSQLString(params);

        buf+=") as TMP_OJ ";
        
        
        for (int i = 0; i < rel.length; i++) {
            buf+=" LEFT OUTER JOIN ";
            buf += " " + rel[i].getName() + " OJ_REL_" + i;
            buf += " ON (";
            for (int j = 0; j < rel[i].getFieldLength(); j++) {
                buf += "TMP_OJ." + "X_" + (offset[i]+j) + " = " +
                    "OJ_REL_"+ i + "." + rel[i].getField(j).getName();
                
                if ( j < rel[i].getFieldLength() - 1) {
                    buf += " AND ";
                }
            }
            buf += ")";

            if (i < rel.length -1) {
                //buf += ",";
            }
        }
        

        return buf;
    }

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }
}
