package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.util.Util;

public abstract class Query
{
    protected static Logger logger = Logger.getLogger(Query.class);

    /* Bit masks for type of the expression 
       corresponding to a given query object */
    public static final int NONE         = 0x0000;
    public static final int RELATION     = 0x0040;
    public static final int SELECTION    = 0x0001;
    public static final int PROJECTION   = 0x0002;
    public static final int PRODUCT      = 0x0004;
    public static final int UNION        = 0x0008;
    public static final int INTERSECTION = 0x0010;
    public static final int DIFFERENCE   = 0x0020;
    public static final int AGGREGATION  = 0x0080;
    public static final int OUTER_JOIN   = 0x0100;

    public abstract int getExprType();

    public abstract String toSQLString(Map params);

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }

}
