package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

public class SelectField extends SelectExpr
{
    protected String bindName;
    protected String fieldName;
    protected String refName;

    public SelectField (String bindName, String fieldName)
    {
        this.bindName  = bindName;
        this.fieldName = fieldName;
    }

    public SelectField (String bindName, String fieldName, String refName)
    {
        this.bindName  = bindName;
        this.fieldName = fieldName;
        this.refName   = refName;
    }

    public String getBindingName()
    {
        return bindName;
    }

    public String getFieldName()
    {
        return fieldName;
    }

    public int getExprType()
    {
        return Query.NONE;
    }

    public String toSQLString(Map params)
    {
        return 
            ((bindName != null) ? (bindName + ".") : ("")) + fieldName + 
            ((refName != null) ? (" AS " + refName) :(""));
    }
}
