package edu.buffalo.nsf.hippo.data.query;

import java.util.List;
import java.util.Map;

import edu.buffalo.nsf.hippo.util.Util;

public class SelectList
{
    protected SelectExpr[] selectExpr;
    protected int          exprType;

    public SelectList(List selectExprs)
    {
        this((SelectExpr[]) selectExprs.toArray(new SelectExpr[0]));
    }

    public SelectList(SelectExpr[] selectExpr)
    {
        this.selectExpr = selectExpr;

        exprType = Query.NONE;
        for (int i = 0; i < selectExpr.length; i++) {
            this.exprType |= selectExpr[i].getExprType();
        }
    }

    public SelectExpr[] getSelectExpr()
    {
        return selectExpr;
    }

    public int getExprType()
    {
        return exprType;
    }

    public String toSQLString(Map params)
    {
        String result = "";

        for (int i = 0; i < selectExpr.length; i++) {
            result += selectExpr[i].toSQLString(params);
            if (i < selectExpr.length - 1) {
                result += ", ";
            }
        }

        return result;
    }

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }
}
