package edu.buffalo.nsf.hippo.data.query.traverse;

import java.util.EmptyStackException;
import java.util.List;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.data.formula.Conjunction;
import edu.buffalo.nsf.hippo.data.formula.Disjunction;
import edu.buffalo.nsf.hippo.data.formula.Formula;
import edu.buffalo.nsf.hippo.data.formula.Negation;
import edu.buffalo.nsf.hippo.util.Util;


public class FormulaStack
{
    protected static Logger logger = Logger.getLogger(FormulaStack.class);

    protected List stack;

    public FormulaStack()
    {
        this.stack = Util.createList();
    }

    public void clear()
    {
        stack.clear();
    }

    public Formula pop()
    {
        if (stack.isEmpty()) {
            throw new EmptyStackException();
        }

        return (Formula) stack.remove(stack.size() - 1);
    }

    public void push(Formula f)
    {
        stack.add(f); 
    }

    public void add(Formula f)
    {
        Formula g = pop();
        push(Conjunction.create(f,g));
    }

    public void union()
    {
        Formula f1 = pop();
        Formula f2 = pop();

        push(Disjunction.create(f1,f2));
    }

    public void negate()
    {
        push(Negation.create(pop()));
    }

    public void fold()
    {
        add(pop());
    }
}
