package edu.buffalo.nsf.hippo.data.query.traverse;


import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configurable;
import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSourceCache;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.formula.Value;
import edu.buffalo.nsf.hippo.data.graph.Vertex;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.SelectExpr;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.WhereCompValue;
import edu.buffalo.nsf.hippo.data.query.WhereComparator;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;

public class KnowledgeHarvester extends QueryWalker implements Configurable
{
    protected Logger logger = Logger.getLogger(KnowledgeHarvester.class);

    protected Environment      env;
    protected Map              schema;
    protected String           coreSuffix;

    public KnowledgeHarvester(Environment env)
    {
        this.env = env;
    }

    public void init(Configuration config)
    {
        this.schema = config.getSchema();
        this.coreSuffix = config.getCoreSuffix();
    }

    public void shutdown()
    {
    }

    protected Relation getRelation(String relName)
    {
        if (relName.endsWith(coreSuffix)) {
            relName = relName.substring(0,relName.length() - coreSuffix.length());
        }

        return (Relation) schema.get(relName);
    }

    protected int varIndex;
    protected DataSourceCache cache;
    protected Tuple t;

    public DataSourceCache gather(Query q, Tuple t)
    {
        varIndex = 0;
        this.t = t;
        cache = new DataSourceCache();

        traverse(q);

        //logger.debug("For the tuple " + t + " I have gathered " + cache);
        
        return cache;
    }

    protected void traverseOuterJoin(Query q, int length, Relation[] rel, int[] offset)
    {
        traverse(q);

        int off = length;

        for (int i = 0; i < rel.length; i++) {
            Tuple t1 = Tuple.extract(t,off,rel[i].getFieldLength());

            if (! t1.isNULL()) {
                Vertex v = Vertex.create(rel[i].getName(), t1);
                if (cache != null) {
                    cache.store(v,true);
                } 
            } else {
                Vertex v = Vertex.create(rel[i].getName(), 
                                         Tuple.extract(t,offset[i],rel[i].getFieldLength()));
                
                if (cache != null) {
                    cache.store(v,false);
                }                
            }

            off += rel[i].getFieldLength();
        
        }
    }


    protected  void traverseSelect(SelectList selectList,
                                   FromList fromList,
                                   WhereCondition whereCondition,
                                   GroupByList groupByList)
    {
        traverseFromList(fromList.getFromExpr());
    }

    protected  void traverseSelectList(SelectExpr[] selectExpr){}

    protected  void traverseSelectConstant(Object c){}
    protected  void traverseSelectField(String bindName, String fieldName){}

    protected  void traverseFromList(FromExpr[] fromExpr)
    {
        for (int i = 0; i < fromExpr.length; i++) {
            traverse(fromExpr[i]);
        }
    }

    protected  void traverseFromRelation(String relName, String bindName)
    {
        Relation r = getRelation(relName);

        Vertex v = Vertex.create(relName,Tuple.extract(t,varIndex,r.getFieldLength()));
        
        if (cache != null) {
            cache.store(v,true);
        }
        
        varIndex += r.getFieldLength();
    }

    protected  void traverseFromSubquery(Query q, String bindName)
    {
        traverse(q);
    }

    protected  void traverseWhereComparison(WhereCompValue val1, 
                                                  WhereComparator comp,
                                                  WhereCompValue val2){}
    protected  void traverseWhereConjunction(WhereCondition cond1,
                                                   WhereCondition cond2){}
    protected  void traverseWhereDisjunction(WhereCondition cond1,
                                                   WhereCondition cond2){}
    protected  void traverseWhereNegation(WhereCondition cond){}

    protected  Value traverseWhereSelectValue(String bindName, String fieldName)
    { return null; }
    protected  Value traverseWhereConstant(Object c){ return null; }


    protected  void traverseDifference   (Query expr1, Query expr2)
    {
        int _varIndex = varIndex;
        
        traverse(expr1);
    }
    
    protected  void traverseIntersection (Query expr1, Query expr2)
    {
        int _varIndex = varIndex;
        
        traverse(expr1);
        
        varIndex = _varIndex;

        traverse(expr2);
    }
    protected  void traverseUnion        (Query expr1, Query expr2)
    {
        DataSourceCache _cache = cache;

        cache = null;

        traverse(expr1);
        
        cache = _cache;
        
    }
}
