package edu.buffalo.nsf.hippo.data.query.traverse;

import java.util.Map;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.InternalProblem;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.formula.Atom;
import edu.buffalo.nsf.hippo.data.formula.Comparator;
import edu.buffalo.nsf.hippo.data.formula.Comparison;
import edu.buffalo.nsf.hippo.data.formula.Constant;
import edu.buffalo.nsf.hippo.data.formula.Formula;
import edu.buffalo.nsf.hippo.data.formula.Value;
import edu.buffalo.nsf.hippo.data.formula.Variable;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.SelectExpr;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.WhereCompValue;
import edu.buffalo.nsf.hippo.data.query.WhereComparator;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.util.Util;

public class SJUIDTranslator extends QueryTranslator
{
    protected Map schema;

    protected FormulaStack f;
    protected BindingStack b;
    
    protected int varIndex;

    protected static final String VAR_PREFIX = "X_";
    
    public SJUIDTranslator(Environment env)
    {
    }
    
    public void init(Configuration config)
    {
        this.schema = config.getSchema();
        this.f = new FormulaStack();
        this.b = new BindingStack();
    }

    public void shutdown()
    {
    }

    public static Map createSubstitution(Tuple t)
    {
        Map s = Util.createMap();

        for (int i = 0; i < t.getFieldCount(); i++) {
            s.put(VAR_PREFIX + i, Constant.create(t.getObject(i)));
        }

        return s;
    }

    public Formula translate(Query q) 
    {
        try {
            varIndex = 0;
            
            f.push(Formula.TRUE);
            
            traverse(q);

            return f.pop();
        } catch (Error err) {
            f.clear();
            b.clear();
            throw err;
        } catch (RuntimeException exc) {
            f.clear();
            b.clear();
            throw exc;
        }
    }
    


    protected void traverseOuterJoin(Query q, int length, Relation[] rel, int[] offset)
    {
        traverse(q);
    }

    protected void traverseSelect(SelectList selectList,
                                FromList fromList,
                                WhereCondition whereCondition,
                                GroupByList groupByList)
    {
        traverseSelectList(selectList.getSelectExpr());
        traverseFromList(fromList.getFromExpr());
        if (whereCondition != null) {
            traverse(whereCondition);
        }

        for (int i = 0 ; i < fromList.getFromExpr().length; i++) {
            if (fromList.getFromExpr()[i] instanceof FromRelation) {
                b.pop();
            }
        }
        
        if (groupByList != null) {
            throw new IllegalArgumentException(
              "This translator can be used only for SJUID queires."
            );
        }
    }

    protected void traverseSelectList(SelectExpr[] selectExpr)
    {
        if (selectExpr.length != 1 || selectExpr[0] != SelectExpr.STAR) {
            throw new IllegalArgumentException(
              "This translator can be used only for projection free queries."
            );
        }
    }

    protected void traverseSelectConstant(Object c)
    {
        throw new IllegalArgumentException(
          "This translator can be used only for projection free queries."
        );
    }
    protected void traverseSelectField(String bindName, String fieldName) 
    {
        throw new IllegalArgumentException(
          "This translator can be used only for projection free queries."
        );
    }

    protected void traverseFromList(FromExpr[] fromExpr)
    {
        for (int i = 0; i < fromExpr.length; i++) {
            traverse(fromExpr[i]);
        }
    }

    protected void traverseFromRelation(String relName, String bindName)
    {
        if (! schema.containsKey(relName)) {
            throw new IllegalArgumentException(
              "Relation " + relName + " not found."
            );
        }

        Relation r = (Relation) schema.get(relName);

        if (bindName != null) { 
            b.push(r,bindName,varIndex);
        } else {
            b.push(r,relName,varIndex);
        }
        
        Value[] v = new Variable[r.getFieldLength()];

        for (int i = 0; i < v.length; i++) {
            v[i] = new Variable(VAR_PREFIX + varIndex++);
        }

        f.add(Atom.create(relName,v));
    }

    protected void traverseFromSubquery(Query q, String bindName)
    {
        //TODO:: binding from the subquery
        traverse(q);
    }

    protected void traverseWhereConjunction(WhereCondition cond1,
                                          WhereCondition cond2)
    {
        traverse(cond1);
        traverse(cond2);
    }

    protected void traverseWhereDisjunction(WhereCondition cond1,
                                          WhereCondition cond2)
    {
        f.push(Formula.TRUE);
        traverse(cond1);        
        f.push(Formula.TRUE);
        traverse(cond2);
        f.union();
    }

    protected void traverseWhereNegation(WhereCondition cond)
    {
        f.push(Formula.TRUE);
        traverse(cond);
        f.negate();
        f.fold();
    }


    protected void traverseWhereComparison(WhereCompValue val1, 
                                         WhereComparator comp,
                                         WhereCompValue val2)
    {
        Value v1 = traverse(val1);
        Value v2 = traverse(val2);

        if (comp == WhereComparator.EQ ) {
          f.add(Comparison.create(v1,Comparator.EQ,v2));
        } else 
        if (comp == WhereComparator.NEQ ) {
          f.add(Comparison.create(v1,Comparator.NEQ,v2));  
        } else 
        if (comp == WhereComparator.LE ) {
          f.add(Comparison.create(v1,Comparator.LE,v2));  
        } else 
        if (comp == WhereComparator.GE ) {
          f.add(Comparison.create(v1,Comparator.GE,v2));  
        } else 
        if (comp == WhereComparator.IS ) {
          f.add(Comparison.create(v1,Comparator.IS,v2));  
        } else {
            throw new InternalProblem("Unrecognized operator " + comp);
        }
    }

    protected Value traverseWhereSelectValue(String bindName, String fieldName)
    {
        if (bindName == null) {
            return new Variable(VAR_PREFIX + b.find(fieldName));
        } else {
            return new Variable(VAR_PREFIX + b.find(bindName,fieldName));
        }
    }

    protected Value traverseWhereConstant(Object c)
    {
        return Constant.create(c);
    }

    protected void traverseDifference   (Query expr1, Query expr2)
    {
        int _varIndex = varIndex;
        traverse(expr1);
        varIndex = _varIndex;
        f.push(Formula.TRUE);
        traverse(expr2);
        f.negate();
        f.fold();
    }

    protected void traverseIntersection (Query expr1, Query expr2)
    {
        int _varIndex = varIndex;
        traverse(expr1);
        varIndex = _varIndex;
        traverse(expr2);
    }

    protected void traverseUnion        (Query expr1, Query expr2)
    {
        int _varIndex = varIndex;
        f.push(Formula.TRUE);
        traverse(expr1);
        varIndex = _varIndex;
        f.push(Formula.TRUE);
        traverse(expr2);
        f.union();
    }
}
