package edu.buffalo.nsf.hippo.data.tuple;


public class ConcatTupleStream extends TupleStream
{
    protected TupleMetaData metaData;
    
    protected TupleStream ts1;
    protected TupleStream ts2;

    public ConcatTupleStream(TupleStream ts1, TupleStream ts2)
    {
        if (! ts1.getMetaData().equals(ts2.getMetaData())) {
            throw new IllegalArgumentException("Meta data mismatch.");
        }

        this.metaData = ts1.getMetaData();
        this.ts1 = ts1;
        this.ts2 = ts2;
    }


    public TupleMetaData getMetaData()
    {
        return metaData;
    }
        
    public boolean hasNext()
    {
        return ts1.hasNext() || ts2.hasNext();
    }
        
    public Tuple getNext()
    {
        if (ts1.hasNext()) {
            return ts1.getNext();
        } else {
            return ts2.getNext();
        }
    }
        
    public String toString()
    {
        return "TSConcat[" + ts1 + "," + ts2 + "]";
    }
}
