package edu.buffalo.nsf.hippo.data.tuple;

import org.apache.log4j.Logger;

public class FilterTupleStream extends TupleStream
{
    protected static Logger logger = Logger.getLogger(FilterTupleStream.class);
    protected boolean     hasNext;
    protected Tuple       next;
    protected TupleStream ts;
    protected TupleFilter f;

    public FilterTupleStream(TupleFilter f,TupleStream ts)
    {
        this.hasNext = true;
        this.ts   = ts;
        this.f    = f;
        this.next = _next();
    }

    public Tuple _next()
    {
        while (ts.hasNext()) {
            Tuple t = ts.getNext();
            //StatsManager.peekStats().touch(Stats.ENVELOPE_TUPLES);
            if (f.check(t)) {
                //StatsManager.peekStats().touch(Stats.GOOD_TUPLES);
                return t;
            } else {
                //StatsManager.peekStats().touch(Stats.BAD_TUPLES);
            }
        }

        hasNext = false;

        return null;
    }

    public TupleMetaData getMetaData()
    {
        return ts.getMetaData();
    }
   
    public boolean hasNext()
    {
        return hasNext;
    }

    public Tuple getNext()
    {
        Tuple result = next;
        next = _next();
        return result;
    }

    public String toString()
    {
        return "FilterTS:[f="+f + ", ts="+ ts +"]";
    }
}
